package aa14f.model.metadata;

import com.google.common.base.Joiner;

import aa14f.model.oids.AA14IDs.AA14OrganizationID;
import aa14f.model.oids.AA14OIDs.AA14OrganizationOID;
import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01f.model.metadata.IndexableFieldID;
import r01f.model.metadata.SearchableFieldID;
import r01f.model.metadata.annotations.DescInLang;
import r01f.model.metadata.annotations.MetaDataForField;
import r01f.model.metadata.annotations.Storage;

public interface AA14HasMetaDataForOrganization {
/////////////////////////////////////////////////////////////////////////////////////////
// SEARCH METADATAS
/////////////////////////////////////////////////////////////////////////////////////////
	@Accessors(prefix="_")
	public enum SEARCHABLE_METADATA
	 implements SearchableFieldID {
		OID ("organizationOid"),
		ID ("organizationId");

		@Getter private final IndexableFieldID _fieldId;

		SEARCHABLE_METADATA(final Object... ids) {
			_fieldId = IndexableFieldID.forId(Joiner.on(".").skipNulls().join(ids).toString());
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////	
	@MetaDataForField(description = {
							@DescInLang(language=Language.SPANISH, value="Identificador nico de Organizacin"),
							@DescInLang(language=Language.BASQUE, value="[eu] Organization's unique identifier"),
							@DescInLang(language=Language.ENGLISH, value="Organization's unique identifier")
					  },
					  storage = @Storage(indexed=true, 
					  					 stored=true))
	public AA14OrganizationOID getOrganizationOid();
	
	@MetaDataForField(description = {
							@DescInLang(language=Language.SPANISH, value="Identificador nico de negocio de la Organizacin"),
							@DescInLang(language=Language.BASQUE, value="[eu] Organization's unique business identifier"),
							@DescInLang(language=Language.ENGLISH, value="Organization's unique business identifier")
					  },
					  storage = @Storage(indexed=true, 
					  					 stored=true))
	public AA14OrganizationID getOrganizationId();
}
