package aa14f.model.metadata;

import com.google.common.base.Joiner;

import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01f.model.metadata.IndexableFieldID;
import r01f.model.metadata.SearchableFieldID;
import r01f.model.metadata.annotations.DescInLang;
import r01f.model.metadata.annotations.MetaDataForField;
import r01f.model.metadata.annotations.Storage;

public interface AA14HasMetaDataForOrgDivisionServiceLocation {
/////////////////////////////////////////////////////////////////////////////////////////
// 	SEARCH METADATAS
/////////////////////////////////////////////////////////////////////////////////////////
	@Accessors(prefix="_")
	public enum SEARCHABLE_METADATA
	 implements SearchableFieldID {
		OID ("orgDivisionServiceLocationOid"),
		ID ("orgDivisionServiceLocationId");

		@Getter private final IndexableFieldID _fieldId;

		SEARCHABLE_METADATA(final Object... ids) {
			_fieldId = IndexableFieldID.forId(Joiner.on(".").skipNulls().join(ids).toString());
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////	
	@MetaDataForField(description = {
							@DescInLang(language=Language.SPANISH, value="Identificador nico de la localizacin del servicio de la divisin de la organizacin"),
							@DescInLang(language=Language.BASQUE, value="[eu] Organization division service location's unique identifier"),
							@DescInLang(language=Language.ENGLISH, value="Organization division service location's unique identifier")
					  },
					  storage = @Storage(indexed=true, 
					  					 stored=true))
	public AA14OrgDivisionServiceLocationOID getOrgDivisionServiceLocationOid();
	
	@MetaDataForField(description = {
							@DescInLang(language=Language.SPANISH, value="Identificador nico de negocio de la localizacin del servicio de la divisin de la organizacin"),
							@DescInLang(language=Language.BASQUE, value="[eu] Organization division service location's unique business identifier"),
							@DescInLang(language=Language.ENGLISH, value="Organization division service location's unique business identifier")
					  },
					  storage = @Storage(indexed=true, 
					  					 stored=true))
	public AA14OrgDivisionServiceLocationID getOrgDivisionServiceLocationId();
}
