package aa14f.common.internal;

import aa14f.common.internal.AA14AppCodes.AA14AppCode;
import r01f.guid.dispenser.GUIDDispenser;
import r01f.guid.dispenser.GUIDDispenserDef;
import r01f.guid.dispenser.SimpleGUIDDispenser;
import r01f.guids.CommonOIDs.AppComponent;
import r01f.xmlproperties.XMLPropertiesBuilder;
import r01f.xmlproperties.XMLPropertiesForAppComponent;

/**
 * Encapsulates some usually used functions as:
 * <ul>
 * 		<li>Property access</li>
 * 		<li>OIDs generation</li>
 * </ul>
 */
public class AA14 {	
/////////////////////////////////////////////////////////////////////////////////////////
// 	GUID GENERATION
/////////////////////////////////////////////////////////////////////////////////////////
    private static final GUIDDispenser GUID_DISPENSER;
    static {
    	XMLPropertiesForAppComponent guidProps = XMLPropertiesBuilder.createForAppComponent(AA14AppCode.API.code(),AppComponent.forId("guids"))
    																		.notUsingCache();
    	GUID_DISPENSER = SimpleGUIDDispenser.create(new GUIDDispenserDef(guidProps,
    																	 "default"));	// default sequence
    }
	/**
	 * Generates a GUID
	 * @return 
	 */
	public static String generateGUID() {
        return GUID_DISPENSER.generateGUID();
	}
}
