package aa14f.client.api.sub.delegates;

import java.util.Collection;

import com.google.inject.Provider;

import aa14f.api.interfaces.AA14CRUDServicesForSchedule;
import aa14f.model.AA14Schedule;
import aa14f.model.oids.AA14IDs.AA14ScheduleID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14ScheduleOID;
import r01f.objectstreamer.Marshaller;
import r01f.securitycontext.SecurityContext;

public class AA14ClientAPIDelegateForScheduleCRUDServices
	 extends AA14ClientAPIDelegateForCRUDServicesBase<AA14ScheduleOID,AA14ScheduleID,AA14Schedule> {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14ClientAPIDelegateForScheduleCRUDServices(final Provider<SecurityContext> securityContextProvider,
													    final Marshaller modelObjectsMarshaller,
														final AA14CRUDServicesForSchedule crudServicesProxy) {
		super(securityContextProvider,
			  modelObjectsMarshaller,
			  crudServicesProxy);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Links an schedule to certain locations
	 * Creates the schedule to service location [many to many] relation
	 * <pre>
	 *          |  SRVC LOC 1   |   SRVC LOC 2    |   SRVC LOC 3
	 *          |===============|=================|================
	 *    SCH 1 |       X       |                 |               
	 *    SCH 2 |               |       X         |      X
	 *    SCH 3 |       X       |       X         |      X
	 * </pre>
	 * @param schOid
	 * @param locOids
	 * @return
	 */
	public AA14Schedule linkScheduleToServiceLocations(final AA14ScheduleOID schOid,	
													   final Collection<AA14OrgDivisionServiceLocationOID> locOids) {
		return this.getServiceProxyAs(AA14CRUDServicesForSchedule.class)
						.linkScheduleToServiceLocations(this.getSecurityContext(),
														schOid,
														locOids)
						.getOrThrow();
	}
}
