package aa14f.client.api.sub;

import com.google.inject.Provider;

import aa14f.api.interfaces.AA14NotifierServices;
import aa14f.model.AA14NotificationOperation;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14SlotOID;
import lombok.experimental.Accessors;
import r01f.objectstreamer.Marshaller;
import r01f.securitycontext.SecurityContext;
import r01f.services.client.api.delegates.ClientAPIServiceDelegateBase;

/**
 * Client implementation of search api
 */
@Accessors(prefix="_")
public class AA14ClientAPIForNotifier
     extends ClientAPIServiceDelegateBase<AA14NotifierServices> {		
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14ClientAPIForNotifier(final Provider<SecurityContext> securityContextProvider,
								    final Marshaller modelObjectsMarshaller,
								    final AA14NotifierServices notifierServicesProxy) {
		super(securityContextProvider,
			  modelObjectsMarshaller,
			  notifierServicesProxy); // reference to other client apis
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Sends a create notification about an appointment creation
	 * @param slotOid
	 * @return
	 */
	public boolean sendCreateNotification(final AA14SlotOID slotOid) {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.sendNotification(this.getSecurityContext(),
										  AA14NotificationOperation.CREATE,
									      slotOid)
						.getOrThrow();
	}
	/**
	 * Sends a create notification about an appointment creation
	 * @param slotOid
	 * @return
	 */
	public boolean sendUpdateNotification(final AA14SlotOID slotOid) {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.sendNotification(this.getSecurityContext(),
										  AA14NotificationOperation.UPDATE,
									      slotOid)
						.getOrThrow();
	}
	/**
	 * Sends a create notification about an appointment creation
	 * @param slotOid
	 * @return
	 */
	public boolean sendDeleteNotification(final AA14SlotOID slotOid) {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.sendNotification(this.getSecurityContext(),
										  AA14NotificationOperation.DELETE,
									      slotOid)
						.getOrThrow();
	}
	/**
	 * Sends a reminder notification about an appointment
	 * @param slotOid
	 * @return
	 */
	public boolean sendRemindTomorrowNotification(final AA14SlotOID slotOid) {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.sendNotification(this.getSecurityContext(),
										  AA14NotificationOperation.REMIND_TOMORROW,
									      slotOid)
						.getOrThrow();
	}
	/**
	 * Sends a reminder notification about an appointment
	 * @param slotOid
	 * @return
	 */
	public boolean sendRemindTodayNotification(final AA14SlotOID slotOid) {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.sendNotification(this.getSecurityContext(),
										  AA14NotificationOperation.REMIND_TODAY,
									      slotOid)
						.getOrThrow();
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////	
	public boolean sendNotification(final AA14NotificationOperation op,
									final AA14SlotOID slotOid) {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.sendNotification(this.getSecurityContext(),
										  op,
										  slotOid)
						.getOrThrow();
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////	
	public boolean existsScheduleNotifierJobFor(final AA14OrgDivisionServiceLocationOID locOid,
												final AA14NotificationOperation op) {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.existsScheduleNotifierJobFor(this.getSecurityContext(),
										  			  locOid,
										  			  op)
						.getOrThrow();
	}
	public boolean scheduleNotifierJobFor(final AA14OrgDivisionServiceLocationOID locOid,
										  final AA14NotificationOperation op) {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.scheduleNotifierJobFor(this.getSecurityContext(),
										  	    locOid,
										  		op)
						.getOrThrow();
	}
	public String schedulerDebugInfo() {
		return this.getServiceProxyAs(AA14NotifierServices.class)
						.schedulerDebugInfo(this.getSecurityContext())
						.getOrThrow();
	}
}
