package aa14f.client.api;

import java.util.Collection;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;

import aa14f.model.AA14OrgDivision;
import aa14f.model.AA14OrgDivisionService;
import aa14f.model.AA14OrgDivisionServiceLocation;
import aa14f.model.AA14Organization;
import aa14f.model.AA14Schedule;
import aa14f.model.AA14ScheduleBookingConfig;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14IDs.AA14ScheduleID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import r01f.locale.Language;
import r01f.types.Color;
import r01f.types.contact.ContactInfo;
import r01f.types.geo.GeoOIDs.GeoZipCode;
import r01f.types.geo.GeoPosition;
import r01f.types.geo.GeoStreet;

@Slf4j
@Singleton
@Accessors(prefix="_")
public class __AA14ConfigForBizilagun 
	 extends AA14ConfigForEJGVBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTS
/////////////////////////////////////////////////////////////////////////////////////////
	// division & service
	public static final AA14OrgDivisionID BIZILAGUN_ID = AA14OrgDivisionID.forId("EJGV_BIZILAGUN");
	public static final AA14OrgDivisionServiceID SERVICE_CONCILIACIONES_ID = AA14OrgDivisionServiceID.forId("BIZILAGUN_CONCILIACIONES");
	public static final AA14OrgDivisionServiceID SERVICE_PROPIEDAD_HORIZONTAL_ID = AA14OrgDivisionServiceID.forId("BIZILAGUN_PROPIEDAD_HORIZONTAL");
	public static final AA14OrgDivisionServiceID SERVICE_ARRENDAMIENTOS_ID = AA14OrgDivisionServiceID.forId("BIZILAGUN_ARRENDAMIENTOS");
	
	// locations
	public static final AA14OrgDivisionServiceLocationID LOC_CONCILIACIONES_GASTEIZ_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_CONCILIACIONES_AR");
	public static final AA14OrgDivisionServiceLocationID LOC_PROPIEDAD_HORIZONTAL_GASTEIZ_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_PROPIEDAD_HORIZONTAL_AR");
	public static final AA14OrgDivisionServiceLocationID LOC_ARRENDAMIENTOS_GASTEIZ_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_ARRENDAMIENTOS_AR");
	
	// colors
	private static final Color COLOR_CONCILIACIONES = Color.from("blue");
	private static final Color COLOR_PROPIEDAD_HORIZONTAL = Color.from("black");
	private static final Color COLOR_ARRENDAMIENTOS = Color.from("yellow");
	
	// schedules
	public static final AA14ScheduleID SCH_CONCILIACIONES_ID = AA14ScheduleID.forId("SCH_CONCILIACIONES");
	public static final AA14ScheduleID SCH_PROPIEDAD_HORIZONTAL_ID = AA14ScheduleID.forId("SCH_PROPIEDAD_HORIZONTAL");
	public static final AA14ScheduleID SCH_ARRENDAMIENTOS_ID = AA14ScheduleID.forId("SCH_PROPIEDAD_ARRENDAMIENTOS");	
	public static final AA14ScheduleID SCH_ALL_ID = AA14ScheduleID.forId("SCH_ALL");
	public static final AA14ScheduleID SCH_PROP_HORIZONTAL_ARRENDAMIENTOS_ID = AA14ScheduleID.forId("SCH_PROPIEDAD_HORIZONTAL_ARRENDAMIENTOS");
	public static final AA14ScheduleID SCH_CONCILIACIONES_PROP_HORIZONTAL_ID = AA14ScheduleID.forId("SCH_CONCILIACIONES_PROP_HORIZONTAL");
	public static final AA14ScheduleID SCH_CONCILIACIONES_ARRENDAMIENTOS_ID = AA14ScheduleID.forId("SCH_CONCILIACIONES_ARRENDAMIENTOS");
	
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14OrgDivisionService getConciliacionesService() {
		return this.getServiceFor(SERVICE_CONCILIACIONES_ID);
	}
	public AA14OrgDivisionService getPropiedadHorizontalService() {
		return this.getServiceFor(SERVICE_PROPIEDAD_HORIZONTAL_ID);
	}
	public AA14OrgDivisionService getArrendamientosService() {
		return this.getServiceFor(SERVICE_ARRENDAMIENTOS_ID);
	}
	public AA14OrgDivisionServiceLocation getConciliacionesLocation() {
		return this.getLocationFor(LOC_CONCILIACIONES_GASTEIZ_ID);
	}
	public AA14OrgDivisionServiceLocation getPropiedadHorizontalLocation() {
		return this.getLocationFor(LOC_PROPIEDAD_HORIZONTAL_GASTEIZ_ID);
	}
	public AA14OrgDivisionServiceLocation getArrendamientosLocation() {
		return this.getLocationFor(LOC_ARRENDAMIENTOS_GASTEIZ_ID);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	protected AA14OrgDivision _loadOrCreateOrgDivisionConfig(final AA14Organization org) {
		// --- Division
		AA14OrgDivision division = _clientApi.orgDivisionsAPI()
											 .getForCRUD()
											 .loadByIdOrNull(BIZILAGUN_ID);
		if (division == null) {
			log.warn("\t[Division]: BIZILAGUN did NOT previously exists... creating it");
			division = _buildDivision(org,
									  AA14OrgDivisionOID.supply(),BIZILAGUN_ID,
									  "Bizilagun","Bizilagun");
			division = _clientApi.orgDivisionsAPI()
									  .getForCRUD()
									  .save(division);
		}
		return division;
	}
	@Override
	protected Collection<AA14OrgDivisionService> _loadOrCreateOrgDivisionServicesConfig(final AA14Organization org,
									  							      			  		final AA14OrgDivision division) {
		Collection<AA14OrgDivisionService> outServices = Lists.newArrayListWithExpectedSize(3);
		// --- Service: Conciliaciones
		{
			AA14OrgDivisionService conciliaciones = _clientApi.orgDivisionServicesAPI()
															  .getForCRUD()
															  .loadByIdOrNull(SERVICE_CONCILIACIONES_ID);
			if (conciliaciones == null) {
				log.warn("\t\t[Service]: BIZILAGUN CONCILIACIONES NOT previously exists... creating it");
				conciliaciones = _buildService(org,
											   division,
											   AA14OrgDivisionServiceOID.supply(),SERVICE_CONCILIACIONES_ID,
											   "Conciliaciones","[eu] Conciliaciones");
				conciliaciones = _clientApi.orgDivisionServicesAPI()
											  .getForCRUD()
											  .save(conciliaciones);
			}
			outServices.add(conciliaciones);
		}
		// --- Service: Propiedad horizontal
		{
			AA14OrgDivisionService propiedadHoriz = _clientApi.orgDivisionServicesAPI()
															  .getForCRUD()
															  .loadByIdOrNull(SERVICE_PROPIEDAD_HORIZONTAL_ID);
			if (propiedadHoriz == null) {
				log.warn("\t\t[Service]: BIZILAGUN PROPIEDAD HORIZONTAL NOT previously exists... creating it");
				propiedadHoriz = _buildService(org,
											   division,
											   AA14OrgDivisionServiceOID.supply(),SERVICE_PROPIEDAD_HORIZONTAL_ID,
											   "Propiedad Horizontal","[eu] Propiedad Horizontal");
				propiedadHoriz = _clientApi.orgDivisionServicesAPI()
											  .getForCRUD()
											  .save(propiedadHoriz);
			}
			outServices.add(propiedadHoriz);
		}
		// --- Service: Arrendamientos
		{
			AA14OrgDivisionService arrendamientos = _clientApi.orgDivisionServicesAPI()
															  .getForCRUD()
															  .loadByIdOrNull(SERVICE_ARRENDAMIENTOS_ID);
			if (arrendamientos == null) {
				log.warn("\t\t[Service]: BIZILAGUN PROPIEDAD HORIZONTAL NOT previously exists... creating it");
				arrendamientos = _buildService(org,
											   division,
											   AA14OrgDivisionServiceOID.supply(),SERVICE_ARRENDAMIENTOS_ID,
											   "Arrendamientos","[eu] Arrendamientos");
				arrendamientos = _clientApi.orgDivisionServicesAPI()
												  .getForCRUD()
												  .save(arrendamientos);
			}
			outServices.add(arrendamientos);
		}
		return outServices;
	}
	@Override
	protected Collection<AA14OrgDivisionServiceLocation> _loadOrCreateOrgDivisionServiceLocationsConfig(final AA14Organization org,
																  							      		final AA14OrgDivision division,
																  							      		final Collection<AA14OrgDivisionService> services) {
		Collection<AA14OrgDivisionServiceLocation> outLocs = Lists.newArrayListWithExpectedSize(3);
		
		// --- Location: Conciliaciones
		{
			AA14OrgDivisionServiceLocation conciliaciones = _clientApi.orgDivisionServiceLocationsAPI()
																		  .getForCRUD()
																		  .loadByIdOrNull(LOC_CONCILIACIONES_GASTEIZ_ID);
			if (conciliaciones == null) {
				log.warn("\t\t\t[Location]: BIZILAGUN.CONCILIACIONES did NOT previously exists... creating it");
				conciliaciones = _buildLocation(org,
												division,
												this.getConciliacionesService(),
												AA14OrgDivisionServiceLocationOID.supply(),LOC_CONCILIACIONES_GASTEIZ_ID,
												"Conciliaciones Gasteiz","[eu] Conciliaciones Gasteiz",
												_buildBiziLagunGasteizGeoPosition(),
												_buildBiziLagunGasteizContactInfo(),
												COLOR_CONCILIACIONES);
				conciliaciones = _clientApi.orgDivisionServiceLocationsAPI()
												  .getForCRUD()
												  .save(conciliaciones);
			}
			outLocs.add(conciliaciones);
		}
		// --- Location: Propiedad Horizontal
		{
			AA14OrgDivisionServiceLocation propiedadHorizontal = _clientApi.orgDivisionServiceLocationsAPI()
																			  .getForCRUD()
																			  .loadByIdOrNull(LOC_PROPIEDAD_HORIZONTAL_GASTEIZ_ID);
			if (propiedadHorizontal == null) {
				log.warn("\t\t\t[Location]: BIZILAGUN.PROPIEDAD HORIZONTAL did NOT previously exists... creating it");
				propiedadHorizontal = _buildLocation(org,
													 division,
													 this.getPropiedadHorizontalService(),
													 AA14OrgDivisionServiceLocationOID.supply(),LOC_PROPIEDAD_HORIZONTAL_GASTEIZ_ID,
													 "Propiedad Horizontal Gasteiz","[eu] Propiedad Horizontal Gasteiz",
													 _buildBiziLagunGasteizGeoPosition(),
													 _buildBiziLagunGasteizContactInfo(),
													 COLOR_PROPIEDAD_HORIZONTAL);
				propiedadHorizontal = _clientApi.orgDivisionServiceLocationsAPI()
														  .getForCRUD()
														  .save(propiedadHorizontal);
			}
			outLocs.add(propiedadHorizontal);
		}
		// --- Location: Arrendamientos
		{
			AA14OrgDivisionServiceLocation arrendamientos = _clientApi.orgDivisionServiceLocationsAPI()
															 				  .getForCRUD()
																			  .loadByIdOrNull(LOC_ARRENDAMIENTOS_GASTEIZ_ID);
			if (arrendamientos == null) {
				log.warn("\t\t\t[Location]: BIZILAGUN.LOC_ARRENDAMIENTOS_GASTEIZ_ID did NOT previously exists... creating it");
				arrendamientos = _buildLocation(org,
											    division,
												this.getArrendamientosService(),
												AA14OrgDivisionServiceLocationOID.supply(),LOC_ARRENDAMIENTOS_GASTEIZ_ID,
												"Arrendamientos Gasteiz","[eu] Arrendamientos Gasteiz",
												 _buildBiziLagunGasteizGeoPosition(),
												 _buildBiziLagunGasteizContactInfo(),
												 COLOR_ARRENDAMIENTOS);
				arrendamientos = _clientApi.orgDivisionServiceLocationsAPI()
												  .getForCRUD()
												  .save(arrendamientos);
			}
			outLocs.add(arrendamientos);
		}
		return outLocs;
	}
	@Override
	protected Collection<AA14Schedule> _loadOrCreateSchedulesConfig(final AA14Organization org,
															  		final AA14OrgDivision division,
															  		final Collection<AA14OrgDivisionService> services,
															  		final Collection<AA14OrgDivisionServiceLocation> locs) {
		Collection<AA14Schedule> outSchs = Lists.newArrayListWithExpectedSize(3);
		
		// Schedule: all
		{
			AA14Schedule all = _clientApi.schedulesAPI()
											  .getForCRUD()
											  .loadByIdOrNull(SCH_ALL_ID);
			if (all == null) {
				log.warn("\t\t\t[Schedule]: BIZILAGUN.ALL did NOT previously exists... creating it");
				all = _buildSchedule(SCH_ALL_ID,
									 "Conciliaciones + Propiedad Horizontal + Arrendamientos","[eu] Conciliaciones + Propiedad Horizontal + Arrendamientos",
									 AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
									 null,		// no qmatic orchestra config
									 this.getConciliacionesLocation(),this.getArrendamientosLocation(),this.getPropiedadHorizontalLocation());
				all = _clientApi.schedulesAPI()
									  .getForCRUD()
									  .save(all);
			}
			outSchs.add(all);
		}
//		// schedule: conciliaciones + arrendamientos
//		{
//			AA14Schedule conciliaciones_arrendamientos = _clientApi.schedulesAPI()
//																	  .getForCRUD()
//																	  .loadByIdOrNull(SCH_CONCILIACIONES_ARRENDAMIENTOS_ID);
//			if (conciliaciones_arrendamientos == null) {
//				log.warn("\t\t\t[Schedule]: BIZILAGUN.SCH_CONCILIACIONES_ARRENDAMIENTOS_ID did NOT previously exists... creating it");
//				conciliaciones_arrendamientos = _buildSchedule(SCH_CONCILIACIONES_ARRENDAMIENTOS_ID,
//															   "Conciliaciones + Arrendamientos","[eu] Conciliaciones + Arrendamientos",
//															   AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
//															   null,		// no qmatic orchestra config
//															   this.getConciliacionesLocation(),this.getArrendamientosLocation());
//				conciliaciones_arrendamientos = _clientApi.schedulesAPI()
//																  .getForCRUD()
//																  .save(conciliaciones_arrendamientos);
//			}
//			outSchs.add(
//		}
//		// schedule: conciliaciones + propiedad horizontal
//		{
//			AA14Schedule conciliaciones_propHoriz = _clientApi.schedulesAPI()
//																	  .getForCRUD()
//																	  .loadByIdOrNull(SCH_CONCILIACIONES_PROP_HORIZONTAL_ID);
//			if (conciliaciones_propHoriz == null) {
//				log.warn("\t\t\t[Schedule]: BIZILAGUN.SCH_CONCILIACIONES_ARRENDAMIENTOS_ID did NOT previously exists... creating it");
//				conciliaciones_propHoriz = _buildSchedule(SCH_CONCILIACIONES_PROP_HORIZONTAL_ID,
//														  "Conciliaciones + Propiedad Horizontal","[eu] Conciliaciones + Propiedad Horizontal",
//														  AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
//														  null,		// no qmatic orchestra config
//														  this.getConciliacionesLocation(),this.getPropiedadHorizontalLocation());
//				conciliaciones_propHoriz = _clientApi.schedulesAPI()
//									  						.getForCRUD()
//									  						.save(conciliaciones_propHoriz);
//			}
//			outSchs.add(conciliaciones_propHoriz);
//		}
//		// schedule: arrendamientos + propiedad horizontal
//		{
//			AA14Schedule arrendamientos_propHoriz = _clientApi.schedulesAPI()
//																	  .getForCRUD()
//																	  .loadByIdOrNull(SCH_PROP_HORIZONTAL_ARRENDAMIENTOS_ID);
//			if (arrendamientos_propHoriz == null) {
//				log.warn("\t\t\t[Schedule]: BIZILAGUN.SCH_PROP_HORIZONTAL_ARRENDAMIENTOS_ID did NOT previously exists... creating it");
//				arrendamientos_propHoriz = _buildSchedule(SCH_PROP_HORIZONTAL_ARRENDAMIENTOS_ID,
//														  "Propiedad Horizontal + Arrendamientos","[eu] Propiedad Horizontal + Arrendamientos",
//														  AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
//														  null,		// no qmatic orchestra config
//														  this.getArrendamientosLocation(),this.getPropiedadHorizontalLocation());
//				arrendamientos_propHoriz = _clientApi.schedulesAPI()
//									  					.getForCRUD()
//									  					.save(arrendamientos_propHoriz);
//			}
//			outSchs.add(arrendamientos_propHoriz);
//		}
		
		// Schedule: conciliaciones
		{
			AA14Schedule conciliaciones = _clientApi.schedulesAPI()
													  .getForCRUD()
													  .loadByIdOrNull(SCH_CONCILIACIONES_ID);
			if (conciliaciones == null) {
				log.warn("\t\t\t[Schedule]: BIZILAGUN.CONCILIACIONES did NOT previously exists... creating it");
				conciliaciones = _buildSchedule(SCH_CONCILIACIONES_ID,
												"Conciliaciones","[eu] Conciliaciones",
												AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
												null,		// no qmatic orchestra config
												this.getConciliacionesLocation());
				conciliaciones = _clientApi.schedulesAPI()
												  .getForCRUD()
												  .save(conciliaciones);
			}
			outSchs.add(conciliaciones);
		}
		// Schedule: propiedad horizontal
		{
			AA14Schedule prop_horizontal = _clientApi.schedulesAPI()
													  .getForCRUD()
													  .loadByIdOrNull(SCH_PROPIEDAD_HORIZONTAL_ID);
			if (prop_horizontal == null) {
				log.warn("\t\t\t[Schedule]: BIZILAGUN.PROPIEDAD HORIZONTAL did NOT previously exists... creating it");
				prop_horizontal = _buildSchedule(SCH_PROPIEDAD_HORIZONTAL_ID,
												"Propiedad Horizontal","[eu] Propiedad Horizontal",
												AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
												null,		// no qmatic orchestra config
												this.getPropiedadHorizontalLocation());
				prop_horizontal = _clientApi.schedulesAPI()
											  .getForCRUD()
											  .save(prop_horizontal);
			}
			outSchs.add(prop_horizontal);
		}
		// Schedule: arrendamientos
		{
			AA14Schedule arrendamientos = _clientApi.schedulesAPI()
													  .getForCRUD()
													  .loadByIdOrNull(SCH_ARRENDAMIENTOS_ID);
			if (arrendamientos == null) {
				log.warn("\t\t\t[Schedule]: BIZILAGUN.ARRENDAMIENTOS did NOT previously exists... creating it");
				arrendamientos = _buildSchedule(SCH_ARRENDAMIENTOS_ID,
												"Arrendamientos","[eu] Arrendamientos",
												AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
												null,		// no qmatic orchestra config
												this.getArrendamientosLocation());
				arrendamientos = _clientApi.schedulesAPI()
												  .getForCRUD()
												  .save(arrendamientos);
			}
			outSchs.add(arrendamientos);
		}
		return outSchs;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	protected static GeoPosition _buildBiziLagunGasteizGeoPosition() {
		return GeoPosition.create()
						  .withCountry(SPAIN)
						  .withTerritory(EUSKADI_TERRITORY)
						  .withState(ARABA_STATE)
						  .withMunicipality(GASTEIZ)
						  .withStreet(GeoStreet.create()
									  	   .withNameInLang(Language.SPANISH,"Calle Samaniego, 2")
							  			   .withNameInLang(Language.BASQUE,"Samaniego kalea, 2"))
						  .withZipCode(GeoZipCode.forId("01008"));
	}
	protected static ContactInfo _buildBiziLagunGasteizContactInfo() {
		return ContactInfo.create()
						 		.addPhones(_buildZuzenenanPhones());
	}
}
