package aa14f.client.api;

import java.util.Collection;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;

import aa14f.model.AA14OrgDivision;
import aa14f.model.AA14OrgDivisionService;
import aa14f.model.AA14OrgDivisionServiceLocation;
import aa14f.model.AA14Organization;
import aa14f.model.AA14Schedule;
import aa14f.model.AA14ScheduleBookingConfig;
import aa14f.model.AA14ScheduleOrchestraConfig;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14IDs.AA14ScheduleID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import r01f.locale.Language;
import r01f.types.Color;
import r01f.types.contact.ContactInfo;
import r01f.types.contact.ContactInfoUsage;
import r01f.types.contact.ContactMail;
import r01f.types.geo.GeoPosition;
import r01f.types.geo.GeoStreet;

@Slf4j
@Singleton
@Accessors(prefix="_")
public class AA14ConfigForTrafikoa 
	 extends AA14ConfigForEJGVBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTS
/////////////////////////////////////////////////////////////////////////////////////////
	public static final AA14OrgDivisionID DIVISION_ID = AA14OrgDivisionID.forId("EJGV_SEGURIDAD");
	public static final AA14OrgDivisionServiceID SERVICE_ID = AA14OrgDivisionServiceID.forId("EJGV_SEGURIDAD_TRAFIKOA");
	              
	public static final AA14OrgDivisionServiceLocationID LOC_BILBAO_ID = AA14OrgDivisionServiceLocationID.forId("EJGV_SEGURIDAD_TRAFIKOA_BILBAO");
	public static final AA14ScheduleID SCH_BILBAO_ID = AA14ScheduleID.forId("SCH_EJGV_SEGURIDAD_TRAFIKOA_BILBAO");
	               
	public static final AA14OrgDivisionServiceLocationID LOC_BILBAO_CATIT_ID = AA14OrgDivisionServiceLocationID.forId("EJGV_SEGURIDAD_TRAFIKOA_BILBAO_CATIT");
	public static final AA14ScheduleID SCH_BILBAO_CATIT_ID = AA14ScheduleID.forId("SCH_EJGV_SEGURIDAD_TRAFIKOA_BILBAO_CATIT");
	               
	public static final AA14OrgDivisionServiceLocationID LOC_DONOSTIA_ID = AA14OrgDivisionServiceLocationID.forId("EJGV_SEGURIDAD_TRAFIKOA_DONOSTIA");
	public static final AA14ScheduleID SCH_DONOSTIA_ID = AA14ScheduleID.forId("SCH_EJGV_SEGURIDAD_TRAFIKOA_DONOSTIA");
	               
	public static final AA14OrgDivisionServiceLocationID LOC_GASTEIZ_ID = AA14OrgDivisionServiceLocationID.forId("EJGV_SEGURIDAD_TRAFIKOA_GASTEIZ");
	public static final AA14ScheduleID SCH_GASTEIZ_ID = AA14ScheduleID.forId("SCH_EJGV_SEGURIDAD_TRAFIKOA_GASTEIZ");
	
	private static final Color COLOR = Color.from("blue"); 
/////////////////////////////////////////////////////////////////////////////////////////
//  GETTERS 
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14OrgDivisionService getTrafikoaService() {
		return FluentIterable.from(this.getMemoizedServicesByOid().get().values())
							 .first().orNull();
	}
	public AA14OrgDivisionServiceLocation getBilbaoLocation() {
		return this.getLocationFor(LOC_BILBAO_ID);
	}
	public AA14OrgDivisionServiceLocation getBilbaoCATITLocation() {
		return this.getLocationFor(LOC_BILBAO_CATIT_ID);
	}
	public AA14OrgDivisionServiceLocation getGasteizLocation() {
		return this.getLocationFor(LOC_GASTEIZ_ID);
	}
	public AA14OrgDivisionServiceLocation getDonostiaLocation() {
		return this.getLocationFor(LOC_DONOSTIA_ID);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  CONFIG BUILDING
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	protected AA14OrgDivision _loadOrCreateOrgDivisionConfig(final AA14Organization org) {
		// --- Division
		AA14OrgDivision division = _clientApi.orgDivisionsAPI()
											 .getForCRUD()
											 .loadByIdOrNull(DIVISION_ID);
		if (division == null) {
			log.warn("\t[Division]: SEGURIDAD did NOT previously exists... creating it");
			division = _buildDivision(org,
									  AA14OrgDivisionOID.supply(),DIVISION_ID,
									  "Departamento de Seguridad","Segurtasuna Saila");
			division = _clientApi.orgDivisionsAPI()
									  .getForCRUD()
									  .save(division);
		}
		return division;
	}
	@Override
	protected Collection<AA14OrgDivisionService> _loadOrCreateOrgDivisionServicesConfig(final AA14Organization org,
									  							     					final AA14OrgDivision division) {
		// --- Service
		AA14OrgDivisionService service = _clientApi.orgDivisionServicesAPI()
												   .getForCRUD()
												   .loadByIdOrNull(SERVICE_ID);
		if (service == null) {
			log.warn("\t\t[Service]: TRAFIKOA did NOT previously exists... creating it");
			service = _buildService(org,
									division,
									AA14OrgDivisionServiceOID.supply(),SERVICE_ID,
									"Trafikoa","Trafikoa");
			_clientApi.orgDivisionServicesAPI()
					  .getForCRUD()
					  .save(service);
		}
		return Lists.newArrayList(service);
	}
	@Override
	protected Collection<AA14OrgDivisionServiceLocation> _loadOrCreateOrgDivisionServiceLocationsConfig(final AA14Organization org,
																  							      		final AA14OrgDivision division,
																  							      		final Collection<AA14OrgDivisionService> services) {
		Collection<AA14OrgDivisionServiceLocation> outLocs = Lists.newArrayListWithExpectedSize(3);
		// --- Location: Bilbao
		{
			AA14OrgDivisionServiceLocation bilbao = _clientApi.orgDivisionServiceLocationsAPI()
															  .getForCRUD()
															  .loadByIdOrNull(LOC_BILBAO_ID);
			if (bilbao == null) {
				log.warn("\t\t\t[Location]: TRAFIKOA.BILBAO did NOT previously exists... creating it");
				bilbao = _buildLocation(org,division,this.getTrafikoaService(),
									    AA14OrgDivisionServiceLocationOID.supply(),LOC_BILBAO_ID,
									    "Trfico Bilbao","Trafikoa Bilbao",
									    GeoPosition.create()
										  .withCountry(SPAIN)
										  .withTerritory(EUSKADI_TERRITORY)
										  .withState(BIZKAIA_STATE)
										  .withMunicipality(BILBAO)
										  .withStreet(GeoStreet.create()
													  	   .withNameInLang(Language.SPANISH,"Gran Va 81, bajo (entrada por M Daz de Haro)")
											  			   .withNameInLang(Language.BASQUE,"Gran Va kalea, 81, b (sarrera M Daz de Haro kaletik)")),
									    ContactInfo.create()
										 .addPhones(_buildZuzenenanPhones())
										 .addMailAddress(_buildTrafikoaInternalMail(LOC_BILBAO_ID)),
										COLOR);
				bilbao = _clientApi.orgDivisionServiceLocationsAPI()
											  .getForCRUD()
											  .save(bilbao);
			}
			outLocs.add(bilbao);
		}
		// --- Location: Bilbao CATIT
		{
			AA14OrgDivisionServiceLocation bilbao_CATIT = _clientApi.orgDivisionServiceLocationsAPI()
																    .getForCRUD()
																    .loadByIdOrNull(LOC_BILBAO_CATIT_ID);
			if (bilbao_CATIT == null) {
				log.warn("\t\t\t[Location]: TRAFIKOA.BILBAO_CATIT did NOT previously exists... creating it");
				bilbao_CATIT = _buildLocation(org,division,this.getTrafikoaService(),
										   	  AA14OrgDivisionServiceLocationOID.supply(),LOC_BILBAO_CATIT_ID,
										   	  "CATIT (Centro Automatizado de Tramitacin de Infracciones de Trfico)","TAIZA (Trafikoko Arau-Hausteak Izapidetzeko Zentro Automatizatua)",
										   	  GeoPosition.create()	
												  .withCountry(SPAIN)
												  .withTerritory(EUSKADI_TERRITORY)
												  .withState(BIZKAIA_STATE)
												  .withMunicipality(BILBAO)
												  .withStreet(GeoStreet.create()
															  	   .withNameInLang(Language.SPANISH,"Calle Doctor Ornilla, 1A -Txurdinaga-")
													  			   .withNameInLang(Language.BASQUE,"Doctor Ornilla kalea, 1A -Txurdinaga-")),
											  ContactInfo.create()
												 .addPhones(_buildZuzenenanPhones())
													 .addMailAddress(_buildTrafikoaInternalMail(LOC_BILBAO_CATIT_ID)),
											  COLOR);
				bilbao_CATIT = _clientApi.orgDivisionServiceLocationsAPI()
											  .getForCRUD()
											  .save(bilbao_CATIT);
			}
			outLocs.add(bilbao_CATIT);
		}
		// --- Location: Donostia
		{
			AA14OrgDivisionServiceLocation donostia = _clientApi.orgDivisionServiceLocationsAPI()
															    .getForCRUD()
															    .loadByIdOrNull(LOC_DONOSTIA_ID);
			if (donostia == null) {
				log.warn("\t\t\t[Location]; TRAFIKOA.DONOSTIA did NOT previously exists... creating it");
				donostia = _buildLocation(org,division,this.getTrafikoaService(),
									   	  AA14OrgDivisionServiceLocationOID.supply(),LOC_DONOSTIA_ID,
									   	  "Trfico Donostia-San Sebastian","Trafikoa Donostia-San Sebastian",
									   	  GeoPosition.create()
											  .withCountry(SPAIN)
											  .withTerritory(EUSKADI_TERRITORY)
											  .withState(GIPUZKOA_STATE)
											  .withMunicipality(DONOSTIA)
											  .withStreet(GeoStreet.create()
														  	   .withNameInLang(Language.SPANISH,"Avenida Vitoria-Gasteiz, 3, 3 planta")
												  			   .withNameInLang(Language.BASQUE,"Vitoria-Gasteiz etorbidea, 3, 3.solairua")),
										  ContactInfo.create()
											 .addPhones(_buildZuzenenanPhones())
											 .addMailAddress(_buildTrafikoaInternalMail(LOC_DONOSTIA_ID)),
										  COLOR);
				donostia = _clientApi.orgDivisionServiceLocationsAPI()
											  .getForCRUD()
											  .save(donostia);
			}
			outLocs.add(donostia);
		}
		// --- Location: Vitoria / Gasteiz
		{
			AA14OrgDivisionServiceLocation gasteiz = _clientApi.orgDivisionServiceLocationsAPI()
															   .getForCRUD()
															   .loadByIdOrNull(LOC_GASTEIZ_ID);
			if (gasteiz == null) {
				log.warn("\t\t\t[Location]: TRAFIKOA.GASTEIZ did NOT previously exists... creating it");
				gasteiz = _buildLocation(org,division,this.getTrafikoaService(),
									     AA14OrgDivisionServiceLocationOID.supply(),LOC_GASTEIZ_ID,
									     "Trfico Vitoria-Gasteiz","Trafikoa Vitoria-Gasteiz",
									     GeoPosition.create()
											  .withCountry(SPAIN)
											  .withTerritory(EUSKADI_TERRITORY)
											  .withState(ARABA_STATE)
											  .withMunicipality(GASTEIZ)
											  .withStreet(GeoStreet.create()
														  	   .withNameInLang(Language.SPANISH,"Calle Samaniego, 2, 5 planta")
												  			   .withNameInLang(Language.BASQUE,"Samaniego kalea, 2, 5.solairua")),
									     ContactInfo.create()
										 	  .addPhones(_buildZuzenenanPhones())
															 .addMailAddress(_buildTrafikoaInternalMail(LOC_GASTEIZ_ID)),
										 COLOR);
				gasteiz = _clientApi.orgDivisionServiceLocationsAPI()
										  .getForCRUD()
										  .save(gasteiz);
			}
			outLocs.add(gasteiz);
		}
		return outLocs;
	}
	@Override
	protected Collection<AA14Schedule> _loadOrCreateSchedulesConfig(final AA14Organization org,
															        final AA14OrgDivision division,
															  		final Collection<AA14OrgDivisionService> services,
															  		final Collection<AA14OrgDivisionServiceLocation> locs) {
		Collection<AA14Schedule> outSchs = Lists.newArrayListWithExpectedSize(3);
		// --- Schedule: Bilbao
		{
			// schedule
			AA14Schedule bilbao_sched = _clientApi.schedulesAPI()
												    .getForCRUD()
												    .loadByIdOrNull(SCH_BILBAO_ID);
			if (bilbao_sched == null) {
				log.warn("\t\t\t[Schedule]: TRAFIKOA.BILBAO SCHEDULE did NOT previously exists... creating it");
				bilbao_sched = _buildSchedule(SCH_BILBAO_ID,
											  "Bilbao schedule","Bilbao schedule",
											  AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
											  new AA14ScheduleOrchestraConfig(false,	// disable orchestra
														  					  "46",		// branch id
																  			  "23"),	// service id
											  this.getBilbaoLocation());
				bilbao_sched = _clientApi.schedulesAPI()
										  .getForCRUD()
										  .save(bilbao_sched);
			}
			outSchs.add(bilbao_sched);
		}
		// --- Schedule: Bilbao CATIT
		{
			AA14Schedule bilbao_CATIT_sched = _clientApi.schedulesAPI()
														    .getForCRUD()
														    .loadByIdOrNull(SCH_BILBAO_CATIT_ID);
			if (bilbao_CATIT_sched == null) {
				log.warn("\t\t\t[Schedule]: TRAFIKOA.BILBAO_CATIT SCHEDULE did NOT previously exists... creating it");
				bilbao_CATIT_sched = _buildSchedule(SCH_BILBAO_CATIT_ID,
													"Bilbao CATIT schedule","Bilbao CATIT schedule",
													AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
													new AA14ScheduleOrchestraConfig(false,	// disable orchestra
																  					"92",	// branch id
																  					"23"),	// service id
													this.getBilbaoCATITLocation());
				bilbao_CATIT_sched = _clientApi.schedulesAPI()
										  .getForCRUD()
										  .save(bilbao_CATIT_sched);
			}
			outSchs.add(bilbao_CATIT_sched);
		}
		// --- Schedule: Donostia
		{
			AA14Schedule donostia_sched = _clientApi.schedulesAPI()
														    .getForCRUD()
														    .loadByIdOrNull(SCH_DONOSTIA_ID);
			if (donostia_sched == null) {
				log.warn("\t\t\t[Schedule]: TRAFIKOA.DONOSTIA SCHEDULE did NOT previously exists... creating it");
				donostia_sched = _buildSchedule(SCH_DONOSTIA_ID,
											    "Donostia schedule","Donostia schedule",
												AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
												new AA14ScheduleOrchestraConfig(false,	// disable orchestra
																  				"47",	// branch id
																  				"23"),	// service id
												this.getDonostiaLocation());
				donostia_sched = _clientApi.schedulesAPI()
										  .getForCRUD()
										  .save(donostia_sched);
			}
			outSchs.add(donostia_sched);
		}
		// --- Schedule: Vitoria / Gasteiz
		{
			AA14Schedule gasteiz_sched = _clientApi.schedulesAPI()
														    .getForCRUD()
														    .loadByIdOrNull(SCH_GASTEIZ_ID);
			if (gasteiz_sched == null) {
				log.warn("\t\t\t[Schedule]: TRAFIKOA.GASTEIZ SCHEDULE did NOT previously exists... creating it");
				gasteiz_sched = _buildSchedule(SCH_GASTEIZ_ID,
											   "Gasteiz schedule","Gasteiz schedule",
											   AA14ScheduleBookingConfig.DEF_BOOKING_CONFIG,
											   new AA14ScheduleOrchestraConfig(false,	// disable orchestra
																  			   "48",	// branch id
																  			   "23"),	// service id
											   this.getGasteizLocation());
				gasteiz_sched = _clientApi.schedulesAPI()
											  .getForCRUD()
											  .save(gasteiz_sched);
			}
			outSchs.add(gasteiz_sched);
		}
		return outSchs;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////

	protected static Collection<ContactMail> _buildTrafikoaInternalMail(final AA14OrgDivisionServiceLocationID locId) {
		if (locId.is(LOC_BILBAO_ID)) {
			return Lists.newArrayList(ContactMail.createToBeUsedFor(ContactInfoUsage.WORK)
												 .mailTo("trafikobi@trafikoa.eus"));
		} else if (locId.is(LOC_GASTEIZ_ID)) {
//			return Lists.newArrayList(ContactMail.createToBeUsedFor(ContactInfoUsage.WORK)
//												 .mailTo("trafikoar@trafikoa.eus"));
		} else if (locId.is(LOC_DONOSTIA_ID)) {
//			return Lists.newArrayList(ContactMail.createToBeUsedFor(ContactInfoUsage.WORK)
//												 .mailTo("trafikogi@trafikoa.eus"));
		} else if (locId.is(LOC_BILBAO_CATIT_ID)) {
//			return Lists.newArrayList(ContactMail.createToBeUsedFor(ContactInfoUsage.WORK)
//												 .mailTo("trafikocatit@trafikoa.eus"));
		}
		return null;
	}
}
