package aa14f.client.api;

import java.util.Collection;

import com.google.common.collect.Lists;

import aa14f.model.AA14Organization;
import aa14f.model.oids.AA14OIDs.AA14OrganizationOID;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import r01f.types.contact.ContactInfoUsage;
import r01f.types.contact.ContactPhone;

@Slf4j
@Accessors(prefix="_")
abstract class AA14ConfigForEJGVBase
	   extends AA14ConfigBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	protected AA14Organization _loadOrCreateOrganizationConfig() {
		// --- Organization
		AA14Organization org = _clientApi.organizationsAPI()
				  						 .getForCRUD()
				  						 .loadByIdOrNull(ORG_ID);
		if (org == null) {
			log.warn("[Org]: EJGV did NOT previously exists... creating it");
			org = _buildOrganization(AA14OrganizationOID.supply(),ORG_ID,
									 "Eusko Jaurlaritza / Gobierno Vasco","Eusko Jaurlaritza / Gobierno Vasco");
			org = _clientApi.organizationsAPI()
								  .getForCRUD()
								  .save(org);
		}
		return org;
	}
	protected static Collection<ContactPhone> _buildZuzenenanPhones() {
		return Lists.newArrayList(ContactPhone.createToBeUsedFor(ContactInfoUsage.WORK)
											  .withNumber("012"),
								  ContactPhone.createToBeUsedFor(ContactInfoUsage.WORK)
											  .withNumber("945018000"));
	}
}