package aa14f.client.api;

import java.util.Collection;

import org.joda.time.LocalDate;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;

import aa14f.model.AA14OrgDivision;
import aa14f.model.AA14OrgDivisionService;
import aa14f.model.AA14OrgDivisionServiceLocation;
import aa14f.model.AA14Organization;
import aa14f.model.AA14Schedule;
import aa14f.model.AA14ScheduleBookingConfig;
import aa14f.model.AA14ScheduleBookingLimit;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14IDs.AA14ScheduleID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import r01f.locale.Language;
import r01f.types.Color;
import r01f.types.contact.ContactInfo;
import r01f.types.datetime.Time;
import r01f.types.geo.GeoOIDs.GeoZipCode;
import r01f.types.geo.GeoPosition;
import r01f.types.geo.GeoStreet;

@Slf4j
@Singleton
@Accessors(prefix="_")
public class AA14ConfigForBloodDonation 
	 extends AA14ConfigForEJGVBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTS
/////////////////////////////////////////////////////////////////////////////////////////
	// division & service
	public static final AA14OrgDivisionID DONATIONS_ID = AA14OrgDivisionID.forId("EJGV_DONACIONES");
	public static final AA14OrgDivisionServiceID SERVICE_ID = AA14OrgDivisionServiceID.forId("DONACIONES_SANGRE");
	
	// locations & schedules
	public static final AA14OrgDivisionServiceLocationID LOC_DONACIONES_SANGRE_AR_ID = AA14OrgDivisionServiceLocationID.forId("DONACIONES_SANGRE_AR");
	public static final AA14ScheduleID SCH_DONACIONES_SANGRE_AR_ID = AA14ScheduleID.forId("SCH_DONACIONES_SANGRE_AR");
		
	public static final AA14OrgDivisionServiceLocationID LOC_DONACIONES_SANGRE_GI_ID = AA14OrgDivisionServiceLocationID.forId("DONACIONES_SANGRE_GI");
	public static final AA14ScheduleID SCH_DONACIONES_SANGRE_GI_ID = AA14ScheduleID.forId("SCH_DONACIONES_SANGRE_GI");
	
	public static final AA14OrgDivisionServiceLocationID LOC_DONACIONES_SANGRE_BIZ_ID = AA14OrgDivisionServiceLocationID.forId("DONACIONES_SANGRE_BIZ");
	public static final AA14ScheduleID SCH_DONACIONES_SANGRE_BIZ_ID = AA14ScheduleID.forId("SCH_DONACIONES_SANGRE_BIZ");
	
	// colors
	private static final Color COLOR_DONACIONES_SANGRE = Color.from("DarkSalmon");
	
	// Texts
	private static final String DONACION_SANGRE_TXT_ES = "Donacin de sangre";
	private static final String DONACION_SANGRE_TXT_EU = "Odol-ematea";
	
	
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14OrgDivisionService getDonacionSangreService() {
		return this.getServiceFor(SERVICE_ID);
	}
	public AA14OrgDivisionServiceLocation getDonacionSangreArabaLocation() {
		return this.getLocationFor(LOC_DONACIONES_SANGRE_AR_ID);
	}
	public AA14OrgDivisionServiceLocation getDonacionSangreGipuzkoaLocation() {
		return this.getLocationFor(LOC_DONACIONES_SANGRE_GI_ID);
	}
	public AA14OrgDivisionServiceLocation getDonacionSangreBizkaiaLocation() {
		return this.getLocationFor(LOC_DONACIONES_SANGRE_BIZ_ID);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	protected AA14OrgDivision _loadOrCreateOrgDivisionConfig(final AA14Organization org) {
		// --- Division
		AA14OrgDivision division = _clientApi.orgDivisionsAPI()
											 .getForCRUD()
											 .loadByIdOrNull(DONATIONS_ID);
		if (division == null) {
			log.warn("\t[Division]: DONACIONES did NOT previously exists... creating it");
			division = _buildDivision(org,
									  AA14OrgDivisionOID.supply(),DONATIONS_ID,
									  "Donaciones","Donazioak");
			division = _clientApi.orgDivisionsAPI()
									  .getForCRUD()
									  .save(division);
		}
		return division;
	}
	@Override
	protected Collection<AA14OrgDivisionService> _loadOrCreateOrgDivisionServicesConfig(final AA14Organization org,
									  							      			  		final AA14OrgDivision division) {
		Collection<AA14OrgDivisionService> outServices = Lists.newArrayListWithExpectedSize(3);
		// --- Service: Donacion de sangre
		{
			AA14OrgDivisionService bloodDonationService = _clientApi.orgDivisionServicesAPI()
																		  .getForCRUD()
																		  .loadByIdOrNull(SERVICE_ID);
			if (bloodDonationService == null) {
				log.warn("\t\t[Service]: DONACIONES. NOT previously exists... creating it");
				bloodDonationService = _buildService(org,
												     division,
													 AA14OrgDivisionServiceOID.supply(),SERVICE_ID,
													 DONACION_SANGRE_TXT_ES,DONACION_SANGRE_TXT_EU);
				bloodDonationService = _clientApi.orgDivisionServicesAPI()
																  .getForCRUD()
																  .save(bloodDonationService);
			}
			outServices.add(bloodDonationService);
		}
		return outServices;
	}
	@Override
	protected Collection<AA14OrgDivisionServiceLocation> _loadOrCreateOrgDivisionServiceLocationsConfig(final AA14Organization org,
																  							      		final AA14OrgDivision division,
																  							      		final Collection<AA14OrgDivisionService> services) {
		Collection<AA14OrgDivisionServiceLocation> outLocs = Lists.newArrayListWithExpectedSize(3);
		
		// --- Location: Donacin de sangre AR
		{
			AA14OrgDivisionServiceLocation donacionSangreAr = _clientApi.orgDivisionServiceLocationsAPI()
																			  .getForCRUD()
																			  .loadByIdOrNull(LOC_DONACIONES_SANGRE_AR_ID);
			if (donacionSangreAr == null) {
				log.warn("\t\t\t[Location]: DONACIONES.Donacin de sangre (AR) did NOT previously exists... creating it");
				donacionSangreAr = _buildLocation(org,
												  division,
												  this.getDonacionSangreService(),
												  AA14OrgDivisionServiceLocationOID.supply(),LOC_DONACIONES_SANGRE_AR_ID,
												  DONACION_SANGRE_TXT_ES + " (AR)",DONACION_SANGRE_TXT_EU + " (AR)",
												  _buildDonationsArabaGeoPosition(),
												  _buildDonationsGasteizContactInfo(),
												  COLOR_DONACIONES_SANGRE);
				donacionSangreAr = _clientApi.orgDivisionServiceLocationsAPI()
															  .getForCRUD()
															  .save(donacionSangreAr);
			}
			outLocs.add(donacionSangreAr);
		}
		
		// --- Location: Donacin de sangre GI
		{
			AA14OrgDivisionServiceLocation donacionSangreGi = _clientApi.orgDivisionServiceLocationsAPI()
																					  .getForCRUD()
																					  .loadByIdOrNull(LOC_DONACIONES_SANGRE_GI_ID);
			if (donacionSangreGi == null) {
				log.warn("\t\t\t[Location]: DONACIONES.Donacin de sangre (GI) did NOT previously exists... creating it");
				donacionSangreGi = _buildLocation(org,
												  division,
												  this.getDonacionSangreService(),
												  AA14OrgDivisionServiceLocationOID.supply(),LOC_DONACIONES_SANGRE_GI_ID,
												  DONACION_SANGRE_TXT_ES + " (GI)",DONACION_SANGRE_TXT_EU + " (GI)",
												  _buildDonationsGipuzkoaGeoPosition(),
												  _buildDonationsGipuzkoaContactInfo(),
												  COLOR_DONACIONES_SANGRE);
				donacionSangreGi = _clientApi.orgDivisionServiceLocationsAPI()
															  .getForCRUD()
															  .save(donacionSangreGi);
			}
			outLocs.add(donacionSangreGi);
		}
		
		// --- Location: Donacin de sangre BIZ
		{
			AA14OrgDivisionServiceLocation donacionSangreBiz = _clientApi.orgDivisionServiceLocationsAPI()
																					  .getForCRUD()
																					  .loadByIdOrNull(LOC_DONACIONES_SANGRE_BIZ_ID);
			if (donacionSangreBiz == null) {
				log.warn("\t\t\t[Location]: DONACIONES.Donacin de sangre (BIZ) did NOT previously exists... creating it");
				donacionSangreBiz = _buildLocation(org,
												   division,
												   this.getDonacionSangreService(),
												   AA14OrgDivisionServiceLocationOID.supply(),LOC_DONACIONES_SANGRE_BIZ_ID,
												   DONACION_SANGRE_TXT_ES + " (BIZ)",DONACION_SANGRE_TXT_EU + " (BIZ)",
												   _buildDonationsBizkaiaGeoPosition(),
												   _buildDonationsBizkaiaContactInfo(),
												   COLOR_DONACIONES_SANGRE);
				donacionSangreBiz = _clientApi.orgDivisionServiceLocationsAPI()
															  .getForCRUD()
															  .save(donacionSangreBiz);
			}
			outLocs.add(donacionSangreBiz);
		}
		
		return outLocs;
	}
	@Override
	protected Collection<AA14Schedule> _loadOrCreateSchedulesConfig(final AA14Organization org,
															  		final AA14OrgDivision division,
															  		final Collection<AA14OrgDivisionService> services,
															  		final Collection<AA14OrgDivisionServiceLocation> locs) {
		Collection<AA14Schedule> outSchs = Lists.newArrayListWithExpectedSize(3);
		
		// Schedule: Donacion de sangre AR
		{
			AA14Schedule donacionSangreSchAr = _clientApi.schedulesAPI()
																	  .getForCRUD()
																	  .loadByIdOrNull(SCH_DONACIONES_SANGRE_AR_ID);
			if (donacionSangreSchAr == null) {
				log.warn("\t\t\t[Schedule]: DONACIONES.Donacin de sangre (AR) did NOT previously exists... creating it");
				donacionSangreSchAr = _buildSchedule(SCH_DONACIONES_SANGRE_AR_ID,
													 DONACION_SANGRE_TXT_ES + " SCHEDULE (AR)",DONACION_SANGRE_TXT_EU + " SCHEDULE (AR)",
													 _createDonationsScheduleBookingConfig(Time.of(9, 0),	 // day bookable range start 
															   							   Time.of(13, 30),// day bookable range end 
															   							   15,			 // slot length
															   							   3),			 // max appointments in slot
													 null,		// no qmatic orchestra config
													 this.getDonacionSangreArabaLocation());
				donacionSangreSchAr = _clientApi.schedulesAPI()
													  .getForCRUD()
													  .save(donacionSangreSchAr);
			}
			outSchs.add(donacionSangreSchAr);
		}
		// Schedule: Donacion de sangre GI
		{
			AA14Schedule donacionSangreSchGi = _clientApi.schedulesAPI()
															  .getForCRUD()
															  .loadByIdOrNull(SCH_DONACIONES_SANGRE_GI_ID);
			if (donacionSangreSchGi == null) {
				log.warn("\t\t\t[Schedule]: DONACIONES.Donacin de sangre (AR) did NOT previously exists... creating it");
				donacionSangreSchGi = _buildSchedule(SCH_DONACIONES_SANGRE_GI_ID,
												     DONACION_SANGRE_TXT_ES + " SCHEDULE (GI)",DONACION_SANGRE_TXT_EU + " SCHEDULE (GI)",
												     _createDonationsScheduleBookingConfig(20,			// slot length
														   								   3),			// max appointments in slot
												     null,		// no qmatic orchestra config
												     this.getDonacionSangreGipuzkoaLocation());
				donacionSangreSchGi = _clientApi.schedulesAPI()
													  .getForCRUD()
													  .save(donacionSangreSchGi);
			}
			outSchs.add(donacionSangreSchGi);
		}
		// Schedule: Donacion de sangre BIZ
		{
			AA14Schedule donacionSangreSchBiz = _clientApi.schedulesAPI()
															  .getForCRUD()
															  .loadByIdOrNull(SCH_DONACIONES_SANGRE_BIZ_ID);
			if (donacionSangreSchBiz == null) {
				log.warn("\t\t\t[Schedule]: DONACIONES.Donacin de sangre (BIZ) did NOT previously exists... creating it");
				donacionSangreSchBiz = _buildSchedule(SCH_DONACIONES_SANGRE_BIZ_ID,
													  DONACION_SANGRE_TXT_ES + " SCHEDULE (BIZ)",DONACION_SANGRE_TXT_EU + " SCHEDULE (BIZ)",
													  _createDonationsScheduleBookingConfig(20,			// slot length
															   								3),			// max appointments in slot
													 null,		// no qmatic orchestra config
													 this.getDonacionSangreBizkaiaLocation());
				donacionSangreSchBiz = _clientApi.schedulesAPI()
													  .getForCRUD()
													  .save(donacionSangreSchBiz);
			}
			outSchs.add(donacionSangreSchBiz);
		}
		
		
		return outSchs;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////
	private static AA14ScheduleBookingConfig _createDonationsScheduleBookingConfig(final int slotLength,
																				   final int maxAppointmentsInSlot) {
		return new AA14ScheduleBookingConfig(Time.of("8:30"),		// day bookable range start 
				    						 Time.of("14:00"),		// day bookable range end
											 slotLength,			// slot length
											 maxAppointmentsInSlot, // max appointments in slot
											 null); // future booking limit (days): 
	}
	
	private static AA14ScheduleBookingConfig _createDonationsScheduleBookingConfig(final Time dayBookableRangeStart,
																				   final Time dayBookableRangeEnd,
																				   final int slotLength,
																				   final int maxAppointmentsInSlot) {
		return new AA14ScheduleBookingConfig(dayBookableRangeStart,		// day bookable range start 
				    						 dayBookableRangeEnd,		// day bookable range end
											 slotLength,			// slot length
											 maxAppointmentsInSlot, // max appointments in slot
											 new AA14ScheduleBookingLimit(new LocalDate(2018,11,2).toDate())); // future booking limit (date): 
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  Location addresses
/////////////////////////////////////////////////////////////////////////////////////////
	protected static GeoPosition _buildDonationsArabaGeoPosition() {
		return GeoPosition.create()
						  .withCountry(SPAIN)
						  .withTerritory(EUSKADI_TERRITORY)
						  .withState(ARABA_STATE)
						  .withMunicipality(GASTEIZ)
						  .withStreet(GeoStreet.create()
									  	   .withNameInLang(Language.SPANISH,"Calle Donostia San Sebastin, 2 (Lakua 2) ") //
							  			   .withNameInLang(Language.BASQUE,"Donostia San Sebastian Kalea, 2 (Lakua 2) "))
						  .withZipCode(GeoZipCode.forId("01010"));
	}
	//FIXME put here the correct phoneNumbers
	protected static ContactInfo _buildDonationsGasteizContactInfo() {
		return ContactInfo.create()
						 		.addPhones(_buildZuzenenanPhones());
	}
	//FIXME put here the correct address
	protected static GeoPosition _buildDonationsGipuzkoaGeoPosition() {
		return GeoPosition.create()
						  .withCountry(SPAIN)
						  .withTerritory(EUSKADI_TERRITORY)
						  .withState(GIPUZKOA_STATE)
						  .withMunicipality(DONOSTIA)
						  .withStreet(GeoStreet.create()
									  	   .withNameInLang(Language.SPANISH,"Andia, 13")
							  			   .withNameInLang(Language.BASQUE,"Andia, 13"))
						  .withZipCode(GeoZipCode.forId("20004"));
	}
	protected static ContactInfo _buildDonationsGipuzkoaContactInfo() {
		return ContactInfo.create()
						 		.addPhones(_buildZuzenenanPhones());
	}
	protected static GeoPosition _buildDonationsBizkaiaGeoPosition() {
		return GeoPosition.create()
						  .withCountry(SPAIN)
						  .withTerritory(EUSKADI_TERRITORY)
						  .withState(BIZKAIA_STATE)
						  .withMunicipality(BILBAO)
						  .withStreet(GeoStreet.create()
									  	   .withNameInLang(Language.SPANISH,"Gran Va, 85")
							  			   .withNameInLang(Language.BASQUE,"Gran Via kalea, 2"))
						  .withZipCode(GeoZipCode.forId("48011"));
	}
	protected static ContactInfo _buildDonationsBizkaiaContactInfo() {
		return ContactInfo.create()
						 		.addPhones(_buildZuzenenanPhones());
	}
}
