package aa14f.client.api;

import java.util.Collection;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;

import aa14f.model.AA14OrgDivision;
import aa14f.model.AA14OrgDivisionService;
import aa14f.model.AA14OrgDivisionServiceLocation;
import aa14f.model.AA14Organization;
import aa14f.model.AA14Schedule;
import aa14f.model.AA14ScheduleBookingConfig;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14IDs.AA14ScheduleID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import r01f.locale.Language;
import r01f.types.Color;
import r01f.types.contact.ContactInfo;
import r01f.types.datetime.Time;
import r01f.types.geo.GeoOIDs.GeoZipCode;
import r01f.types.geo.GeoPosition;
import r01f.types.geo.GeoStreet;

@Slf4j
@Singleton
@Accessors(prefix="_")
public class AA14ConfigForBizilagun 
	 extends AA14ConfigForEJGVBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTS
/////////////////////////////////////////////////////////////////////////////////////////
	// division & service
	public static final AA14OrgDivisionID BIZILAGUN_ID = AA14OrgDivisionID.forId("EJGV_BIZILAGUN");
	public static final AA14OrgDivisionServiceID SERVICE_FIANZAS_DEPOSITO_CONTRATOS_ID = AA14OrgDivisionServiceID.forId("BIZILAGUN_FIANZAS_DEPOSITO_CONTRATOS");
	public static final AA14OrgDivisionServiceID SERVICE_COMUNIDADES_ALQUILERES_ID = AA14OrgDivisionServiceID.forId("BIZILAGUN_COMUNIDADES_ALQUILERES");
	
	// locations & schedules
	public static final AA14OrgDivisionServiceLocationID LOC_FIANZAS_DEPOSITO_CONTRATOS_AR_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_FIANZAS_DEPOSITO_CONTRATOS_AR");
	public static final AA14ScheduleID SCH_FIANZAS_DEPOSITO_CONTRATOS_AR_ID = AA14ScheduleID.forId("SCH_BIZILAGUN_FIANZAS_DEPOSITO_CONTRATOS_AR");

	public static final AA14OrgDivisionServiceLocationID LOC_FIANZAS_DEPOSITO_CONTRATOS_GI_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_FIANZAS_DEPOSITO_CONTRATOS_GI");
	public static final AA14ScheduleID SCH_FIANZAS_DEPOSITO_CONTRATOS_GI_ID = AA14ScheduleID.forId("SCH_BIZILAGUN_FIANZAS_DEPOSITO_CONTRATOS_GI");
	
	public static final AA14OrgDivisionServiceLocationID LOC_FIANZAS_DEPOSITO_CONTRATOS_BIZ_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_FIANZAS_DEPOSITO_CONTRATOS_BIZ");
	public static final AA14ScheduleID SCH_FIANZAS_DEPOSITO_CONTRATOS_BIZ_ID = AA14ScheduleID.forId("SCH_BIZILAGUN_FIANZAS_DEPOSITO_CONTRATOS_BIZ");	
	
	
	
	public static final AA14OrgDivisionServiceLocationID LOC_COMUNIDADES_ALQUILERES_AR_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_COMUNIDADES_ALQUILERES_AR");
	public static final AA14ScheduleID SCH_COMUNIDADES_ALQUILERES_AR_ID = AA14ScheduleID.forId("SCH_BIZILAGUN_COMUNIDADES_ALQUILERES_AR");
	
	public static final AA14OrgDivisionServiceLocationID LOC_COMUNIDADES_ALQUILERES_GI_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_COMUNIDADES_ALQUILERES_GI");
	public static final AA14ScheduleID SCH_COMUNIDADES_ALQUILERES_GI_ID = AA14ScheduleID.forId("SCH_BIZILAGUN_COMUNIDADES_ALQUILERES_GI");
	
	public static final AA14OrgDivisionServiceLocationID LOC_COMUNIDADES_ALQUILERES_BIZ_ID = AA14OrgDivisionServiceLocationID.forId("BIZILAGUN_COMUNIDADES_ALQUILERES_BIZ");
	public static final AA14ScheduleID SCH_COMUNIDADES_ALQUILERES_BIZ_ID = AA14ScheduleID.forId("SCH_BIZILAGUN_COMUNIDADES_ALQUILERES_BIZ");
	
	// colors
	private static final Color COLOR_FIANZAS_DEPOSITO_CONTRATOS = Color.from("blue");
	private static final Color COLOR_COMUNIDADES_ALQUILERES = Color.from("black");
	
	// Texts
	private static final String FIANZAS_TXT_ES = "Depsito de fianzas y registro de contratos de arrendamiento de fincas urbanas";
	private static final String COMUNIDADES_TXT_ES = "Consultas sobre Comunidades y alquileres";
	
	private static final String FIANZAS_TXT_EU = "Fidantzak jartzea eta hiri finken errentamendu kontratuen erregistroa";
	private static final String COMUNIDADES_TXT_EU = "Komunitateak eta alokairuak";
	
	
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14OrgDivisionService getFianzasDepositosContratosService() {
		return this.getServiceFor(SERVICE_FIANZAS_DEPOSITO_CONTRATOS_ID);
	}
	public AA14OrgDivisionService getComunidadesAlquileresService() {
		return this.getServiceFor(SERVICE_COMUNIDADES_ALQUILERES_ID);
	}
	public AA14OrgDivisionServiceLocation getFianzasDepositosContratosArabaLocation() {
		return this.getLocationFor(LOC_FIANZAS_DEPOSITO_CONTRATOS_AR_ID);
	}
	public AA14OrgDivisionServiceLocation getComunidadesAlquileresLocationAraba() {
		return this.getLocationFor(LOC_COMUNIDADES_ALQUILERES_AR_ID);
	}
	public AA14OrgDivisionServiceLocation getComunidadesAlquileresLocationGipuzkoa() {
		return this.getLocationFor(LOC_COMUNIDADES_ALQUILERES_GI_ID);
	}
	public AA14OrgDivisionServiceLocation getComunidadesAlquileresLocationBizkaia() {
		return this.getLocationFor(LOC_COMUNIDADES_ALQUILERES_BIZ_ID);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	protected AA14OrgDivision _loadOrCreateOrgDivisionConfig(final AA14Organization org) {
		// --- Division
		AA14OrgDivision division = _clientApi.orgDivisionsAPI()
											 .getForCRUD()
											 .loadByIdOrNull(BIZILAGUN_ID);
		if (division == null) {
			log.warn("\t[Division]: BIZILAGUN did NOT previously exists... creating it");
			division = _buildDivision(org,
									  AA14OrgDivisionOID.supply(),BIZILAGUN_ID,
									  "Bizilagun","Bizilagun");
			division = _clientApi.orgDivisionsAPI()
									  .getForCRUD()
									  .save(division);
		}
		return division;
	}
	@Override
	protected Collection<AA14OrgDivisionService> _loadOrCreateOrgDivisionServicesConfig(final AA14Organization org,
									  							      			  		final AA14OrgDivision division) {
		Collection<AA14OrgDivisionService> outServices = Lists.newArrayListWithExpectedSize(3);
		// --- Service: Fianzas y depsito de contratos
		{
			AA14OrgDivisionService fianzasDepositoContratosService = _clientApi.orgDivisionServicesAPI()
																				  .getForCRUD()
																				  .loadByIdOrNull(SERVICE_FIANZAS_DEPOSITO_CONTRATOS_ID);
			if (fianzasDepositoContratosService == null) {
				log.warn("\t\t[Service]: BIZILAGUN.Fianzas y depsito de contratos NOT previously exists... creating it");
				fianzasDepositoContratosService = _buildService(org,
															    division,
															    AA14OrgDivisionServiceOID.supply(),SERVICE_FIANZAS_DEPOSITO_CONTRATOS_ID,
															    FIANZAS_TXT_ES,FIANZAS_TXT_EU);
				fianzasDepositoContratosService = _clientApi.orgDivisionServicesAPI()
																  .getForCRUD()
																  .save(fianzasDepositoContratosService);
			}
			outServices.add(fianzasDepositoContratosService);
		}
		// --- Service: Comunidades y Alquileres
		{
			AA14OrgDivisionService comunidadesAlquileresService = _clientApi.orgDivisionServicesAPI()
																				  .getForCRUD()
																				  .loadByIdOrNull(SERVICE_COMUNIDADES_ALQUILERES_ID);
			if (comunidadesAlquileresService == null) {
				log.warn("\t\t[Service]: BIZILAGUN.Comunidades y Alquileres NOT previously exists... creating it");
				comunidadesAlquileresService = _buildService(org,
														     division,
														     AA14OrgDivisionServiceOID.supply(),SERVICE_COMUNIDADES_ALQUILERES_ID,
														     COMUNIDADES_TXT_ES,COMUNIDADES_TXT_EU);
				comunidadesAlquileresService = _clientApi.orgDivisionServicesAPI()
															  .getForCRUD()
															  .save(comunidadesAlquileresService);
			}
			outServices.add(comunidadesAlquileresService);
		}
		return outServices;
	}
	@Override
	protected Collection<AA14OrgDivisionServiceLocation> _loadOrCreateOrgDivisionServiceLocationsConfig(final AA14Organization org,
																  							      		final AA14OrgDivision division,
																  							      		final Collection<AA14OrgDivisionService> services) {
		Collection<AA14OrgDivisionServiceLocation> outLocs = Lists.newArrayListWithExpectedSize(3);
		
		// --- Location: Fianzas y depsito de contratos AR
		{
			AA14OrgDivisionServiceLocation fianzasDepositoContratosAr = _clientApi.orgDivisionServiceLocationsAPI()
																					  .getForCRUD()
																					  .loadByIdOrNull(LOC_FIANZAS_DEPOSITO_CONTRATOS_AR_ID);
			if (fianzasDepositoContratosAr == null) {
				log.warn("\t\t\t[Location]: BIZILAGUN.Fianzas y Deposito de contratos (AR) did NOT previously exists... creating it");
				fianzasDepositoContratosAr = _buildLocation(org,
															division,
															this.getFianzasDepositosContratosService(),
															AA14OrgDivisionServiceLocationOID.supply(),LOC_FIANZAS_DEPOSITO_CONTRATOS_AR_ID,
															FIANZAS_TXT_ES + " (AR)",FIANZAS_TXT_EU + " (AR)",
															_buildBiziLagunArabaGeoPosition(),
															_buildBiziLagunGasteizContactInfo(),
															COLOR_FIANZAS_DEPOSITO_CONTRATOS);
				fianzasDepositoContratosAr = _clientApi.orgDivisionServiceLocationsAPI()
															  .getForCRUD()
															  .save(fianzasDepositoContratosAr);
			}
			outLocs.add(fianzasDepositoContratosAr);
		}
		// --- Location: Comunidades y Alquileres AR
		{
			AA14OrgDivisionServiceLocation comunidadesAlquileresAr = _clientApi.orgDivisionServiceLocationsAPI()
																			  .getForCRUD()
																			  .loadByIdOrNull(LOC_COMUNIDADES_ALQUILERES_AR_ID);
			if (comunidadesAlquileresAr == null) {
				log.warn("\t\t\t[Location]: BIZILAGUN.Comunidades y Alquileres (AR) did NOT previously exists... creating it");
				comunidadesAlquileresAr = _buildLocation(org,
													 division,
													 this.getComunidadesAlquileresService(),
													 AA14OrgDivisionServiceLocationOID.supply(),LOC_COMUNIDADES_ALQUILERES_AR_ID,
													 COMUNIDADES_TXT_ES + " (AR)",COMUNIDADES_TXT_EU + " (AR)",
													 _buildBiziLagunArabaGeoPosition(),
													 _buildBiziLagunGasteizContactInfo(),
													 COLOR_COMUNIDADES_ALQUILERES);
				comunidadesAlquileresAr = _clientApi.orgDivisionServiceLocationsAPI()
														  .getForCRUD()
														  .save(comunidadesAlquileresAr);
			}
			outLocs.add(comunidadesAlquileresAr);
		}
		// --- Location: Comunidades y Alquileres GI
		{
			AA14OrgDivisionServiceLocation comunidadesAlquileresGi = _clientApi.orgDivisionServiceLocationsAPI()
																				  .getForCRUD()
																				  .loadByIdOrNull(LOC_COMUNIDADES_ALQUILERES_GI_ID);
			if (comunidadesAlquileresGi == null) {
				log.warn("\t\t\t[Location]: BIZILAGUN.Comunidades y Alquileres (GI) did NOT previously exists... creating it");
				comunidadesAlquileresGi = _buildLocation(org,
													 division,
													 this.getComunidadesAlquileresService(),
													 AA14OrgDivisionServiceLocationOID.supply(),LOC_COMUNIDADES_ALQUILERES_GI_ID,
													 COMUNIDADES_TXT_ES + " (GI)",COMUNIDADES_TXT_EU + " (GI)",
													 _buildBiziLagunGipuzkoaGeoPosition(),
													 _buildBiziLagunGipuzkoaContactInfo(),
													 COLOR_COMUNIDADES_ALQUILERES);
				comunidadesAlquileresGi = _clientApi.orgDivisionServiceLocationsAPI()
														  .getForCRUD()
														  .save(comunidadesAlquileresGi);
			}
			outLocs.add(comunidadesAlquileresGi);
		}
		// --- Location: Comunidades y Alquileres BIZ
		{
			AA14OrgDivisionServiceLocation comunidadesAlquileresBiz = _clientApi.orgDivisionServiceLocationsAPI()
																				  .getForCRUD()
																				  .loadByIdOrNull(LOC_COMUNIDADES_ALQUILERES_BIZ_ID);
			if (comunidadesAlquileresBiz == null) {
				log.warn("\t\t\t[Location]: BIZILAGUN.Comunidades y Alquileres (BIZ) did NOT previously exists... creating it");
				comunidadesAlquileresBiz = _buildLocation(org,
													 division,
													 this.getComunidadesAlquileresService(),
													 AA14OrgDivisionServiceLocationOID.supply(),LOC_COMUNIDADES_ALQUILERES_BIZ_ID,
													 COMUNIDADES_TXT_ES + " (BIZ)",COMUNIDADES_TXT_EU + " (BIZ)",
													 _buildBiziLagunBizkaiaGeoPosition(),
													 _buildBiziLagunBizkaiaContactInfo(),
													 COLOR_COMUNIDADES_ALQUILERES);
				comunidadesAlquileresBiz = _clientApi.orgDivisionServiceLocationsAPI()
														  .getForCRUD()
														  .save(comunidadesAlquileresBiz);
			}
			outLocs.add(comunidadesAlquileresBiz);
		}
		return outLocs;
	}
	@Override
	protected Collection<AA14Schedule> _loadOrCreateSchedulesConfig(final AA14Organization org,
															  		final AA14OrgDivision division,
															  		final Collection<AA14OrgDivisionService> services,
															  		final Collection<AA14OrgDivisionServiceLocation> locs) {
		Collection<AA14Schedule> outSchs = Lists.newArrayListWithExpectedSize(3);
		
		// Schedule: Fianzas y depsito de contratos AR
		{
			AA14Schedule fianzasDepositoContratosSchAr = _clientApi.schedulesAPI()
																	  .getForCRUD()
																	  .loadByIdOrNull(SCH_FIANZAS_DEPOSITO_CONTRATOS_AR_ID);
			if (fianzasDepositoContratosSchAr == null) {
				log.warn("\t\t\t[Schedule]: BIZILAGUN.Fianzas y depsito de contratos (AR) did NOT previously exists... creating it");
				fianzasDepositoContratosSchAr = _buildSchedule(SCH_FIANZAS_DEPOSITO_CONTRATOS_AR_ID,
															   FIANZAS_TXT_ES + " SCHEDULE (AR)",FIANZAS_TXT_EU + " SCHEDULE (AR)",
															   _createBizilagunScheduleBookingConfig(30,			// slot length
																	   								 3),			// max appointments in slot
															   null,		// no qmatic orchestra config
															   this.getFianzasDepositosContratosArabaLocation());
				fianzasDepositoContratosSchAr = _clientApi.schedulesAPI()
																  .getForCRUD()
																  .save(fianzasDepositoContratosSchAr);
			}
			outSchs.add(fianzasDepositoContratosSchAr);
		}
		// Schedule: Comunidades y Alquileres AR
		{
			AA14Schedule comunidadesAlquileresSchAr = _clientApi.schedulesAPI()
																	  .getForCRUD()
																	  .loadByIdOrNull(SCH_COMUNIDADES_ALQUILERES_AR_ID);
			if (comunidadesAlquileresSchAr == null) {
				log.warn("\t\t\t[Schedule]: BIZILAGUN.Comunidades y Alquileres (AR) did NOT previously exists... creating it");
				comunidadesAlquileresSchAr = _buildSchedule(SCH_COMUNIDADES_ALQUILERES_AR_ID,
															COMUNIDADES_TXT_ES + " SCHEDULE (AR)",COMUNIDADES_TXT_EU + " SCHEDULE (AR)",
															_createBizilagunScheduleBookingConfig(30,				// slot length
																								  2),				// max appointments in slot
															null,		// no qmatic orchestra config
															this.getComunidadesAlquileresLocationAraba());
				comunidadesAlquileresSchAr = _clientApi.schedulesAPI()
														  .getForCRUD()
														  .save(comunidadesAlquileresSchAr);
			}
			outSchs.add(comunidadesAlquileresSchAr);
		}
		// Schedule: Comunidades y Alquileres GI
		{
			AA14Schedule comunidadesAlquileresSchGi = _clientApi.schedulesAPI()
																  .getForCRUD()
																  .loadByIdOrNull(SCH_COMUNIDADES_ALQUILERES_GI_ID);
			if (comunidadesAlquileresSchGi == null) {
				log.warn("\t\t\t[Schedule]: BIZILAGUN.Comunidades y Alquileres (GI) did NOT previously exists... creating it");
				comunidadesAlquileresSchGi = _buildSchedule(SCH_COMUNIDADES_ALQUILERES_GI_ID,
															COMUNIDADES_TXT_ES + " SCHEDULE (GI)",COMUNIDADES_TXT_EU + " SCHEDULE (GI)",
															_createBizilagunScheduleBookingConfig(15,				// slot length
																								  1),				// max appointments in slot
															null,		// no qmatic orchestra config
															this.getComunidadesAlquileresLocationGipuzkoa());
				comunidadesAlquileresSchGi = _clientApi.schedulesAPI()
														  .getForCRUD()
														  .save(comunidadesAlquileresSchGi);
			}
			outSchs.add(comunidadesAlquileresSchGi);
		}
		// Schedule: Comunidades y Alquileres BIZ
		{
			AA14Schedule comunidadesAlquileresSchBiz = _clientApi.schedulesAPI()
																	.getForCRUD()
																	.loadByIdOrNull(SCH_COMUNIDADES_ALQUILERES_BIZ_ID);
			if (comunidadesAlquileresSchBiz == null) {
				log.warn("\t\t\t[Schedule]: BIZILAGUN.Comunidades y Alquileres (BIZ) did NOT previously exists... creating it");
				comunidadesAlquileresSchBiz = _buildSchedule(SCH_COMUNIDADES_ALQUILERES_BIZ_ID,
															COMUNIDADES_TXT_ES + " SCHEDULE (BIZ)",COMUNIDADES_TXT_EU + " SCHEDULE (BIZ)",
															_createBizilagunScheduleBookingConfig(15,				// slot length
																								  1),				// max appointments in slot
															null,		// no qmatic orchestra config
															this.getComunidadesAlquileresLocationBizkaia());
				comunidadesAlquileresSchBiz = _clientApi.schedulesAPI()
														  .getForCRUD()
														  .save(comunidadesAlquileresSchBiz);
			}
			outSchs.add(comunidadesAlquileresSchBiz);
		}
		return outSchs;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////
	private static AA14ScheduleBookingConfig _createBizilagunScheduleBookingConfig(final int slotLength,
																				   final int maxAppointmentsInSlot) {
		return new AA14ScheduleBookingConfig(Time.of("8:30"),		// day bookable range start 
				    						 Time.of("14:00"),		// day bookable range end
											 slotLength,			// slot length
											 maxAppointmentsInSlot,	// max appointments in slot
											 null);					// future booking limit (no limit)
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  TODO revisar localizaciones
/////////////////////////////////////////////////////////////////////////////////////////
	protected static GeoPosition _buildBiziLagunArabaGeoPosition() {
		return GeoPosition.create()
						  .withCountry(SPAIN)
						  .withTerritory(EUSKADI_TERRITORY)
						  .withState(ARABA_STATE)
						  .withMunicipality(GASTEIZ)
						  .withStreet(GeoStreet.create()
									  	   .withNameInLang(Language.SPANISH,"Calle Samaniego, 2")
							  			   .withNameInLang(Language.BASQUE,"Samaniego kalea, 2"))
						  .withZipCode(GeoZipCode.forId("01008"));
	}
	protected static ContactInfo _buildBiziLagunGasteizContactInfo() {
		return ContactInfo.create()
						 		.addPhones(_buildZuzenenanPhones());
	}
	protected static GeoPosition _buildBiziLagunGipuzkoaGeoPosition() {
		return GeoPosition.create()
						  .withCountry(SPAIN)
						  .withTerritory(EUSKADI_TERRITORY)
						  .withState(GIPUZKOA_STATE)
						  .withMunicipality(DONOSTIA)
						  .withStreet(GeoStreet.create()
									  	   .withNameInLang(Language.SPANISH,"Andia, 13")
							  			   .withNameInLang(Language.BASQUE,"Andia, 13"))
						  .withZipCode(GeoZipCode.forId("20004"));
	}
	protected static ContactInfo _buildBiziLagunGipuzkoaContactInfo() {
		return ContactInfo.create()
						 		.addPhones(_buildZuzenenanPhones());
	}
	protected static GeoPosition _buildBiziLagunBizkaiaGeoPosition() {
		return GeoPosition.create()
						  .withCountry(SPAIN)
						  .withTerritory(EUSKADI_TERRITORY)
						  .withState(BIZKAIA_STATE)
						  .withMunicipality(BILBAO)
						  .withStreet(GeoStreet.create()
									  	   .withNameInLang(Language.SPANISH,"Gran Va, 85")
							  			   .withNameInLang(Language.BASQUE,"Gran Va kalea, 2"))
						  .withZipCode(GeoZipCode.forId("48011"));
	}
	protected static ContactInfo _buildBiziLagunBizkaiaContactInfo() {
		return ContactInfo.create()
						 		.addPhones(_buildZuzenenanPhones());
	}
}
