package aa14f.api.interfaces;

import aa14f.model.AA14NotificationOperation;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14SlotOID;
import r01f.model.persistence.PersistenceOperationExecResult;
import r01f.securitycontext.SecurityContext;
import r01f.services.interfaces.ExposedServiceInterface;

@ExposedServiceInterface
public interface AA14NotifierServices 
		 extends AA14ServiceInterface {
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////	
	/**
	 * Sends a notification about an appointment operation
	 * @param securityContext
	 * @param slotOid
	 * @return
	 */
	public PersistenceOperationExecResult<Boolean> 	sendNotification(final SecurityContext securityContext,
																	 final AA14NotificationOperation op,
								 									 final AA14SlotOID slotOid);
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Check if it exists a scheduled notifier job for appointments at a given location
	 * @param securityContext
	 * @param locOid
	 * @param op
	 * @return true if the notifier job was scheduled
	 */
	public PersistenceOperationExecResult<Boolean> existsScheduleNotifierJobFor(final SecurityContext securityContext,
																		  		final AA14OrgDivisionServiceLocationOID locOid,
																		  		final AA14NotificationOperation op);
	/**
	 * Schedules a notifier job for appointments at a given location
	 * @param securityContext
	 * @param locOid
	 * @param op
	 * @return true if the notifier job was scheduled
	 */
	public PersistenceOperationExecResult<Boolean> scheduleNotifierJobFor(final SecurityContext securityContext,
																		  final AA14OrgDivisionServiceLocationOID locOid,
										  				  				  final AA14NotificationOperation op);
	/**
	 * Returns debug info about the scheduler status
	 * @param securityContext
	 * @return
	 */
	public PersistenceOperationExecResult<String> schedulerDebugInfo(final SecurityContext securityContext);
}
