package aa14f.api.interfaces;

import java.util.Date;

import aa14f.model.AA14Appointment;
import aa14f.model.AA14BookedSlot;
import aa14f.model.AA14BookedSlotType;
import aa14f.model.AA14NonBookableSlot;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14IDs.AA14SlotID;
import aa14f.model.oids.AA14OIDs.AA14AppointmentSubjectID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14PeriodicSlotSerieOID;
import aa14f.model.oids.AA14OIDs.AA14ScheduleOID;
import aa14f.model.oids.AA14OIDs.AA14SlotOID;
import r01f.locale.Language;
import r01f.model.persistence.FindOIDsResult;
import r01f.model.persistence.FindResult;
import r01f.model.persistence.FindSummariesResult;
import r01f.securitycontext.SecurityContext;
import r01f.services.interfaces.ExposedServiceInterface;
import r01f.types.Range;
import r01f.types.contact.PersonID;

@ExposedServiceInterface
public interface AA14FindServicesForBookedSlot
         extends AA14FindServicesBase<AA14SlotOID,AA14SlotID,AA14BookedSlot> {
/////////////////////////////////////////////////////////////////////////////////////////
//  RANGE BOOKED SLOTS BY SCHEDULE
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Finds slots in a date range
	 * @param securityContext
	 * @param schOid
	 * @param dateRange
	 * @return
	 */
	public FindResult<AA14BookedSlot> findRangeBookedSlotsFor(final SecurityContext securityContext,
										   					  final AA14ScheduleOID schOid,
										   					  final Range<Date> dateRange);
	/**
	 * Finds slots in a date range
	 * @param securityContext
	 * @param schOid
	 * @param dateRange
	 * @return
	 */
	public FindSummariesResult<AA14BookedSlot> findRangeBookedSlotsSummarizedFor(final SecurityContext securityContext,
																				 final Language lang,
																  				 final AA14ScheduleOID schOid,
																  				 final Range<Date> dateRange);
/////////////////////////////////////////////////////////////////////////////////////////
//  RANGE BOOKED SLOTS BY SERVICE LOCATION
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Finds slots of a certain type in a date range
	 * @param securityContext
	 * @param locationOid
	 * @param dateRange
	 * @param slotType
	 * @return
	 */
	public FindOIDsResult<AA14SlotOID> findRangeBookedSlotsFor(final SecurityContext securityContext,
															   final AA14OrgDivisionServiceLocationOID locationOid,
										   					   final Range<Date> dateRange,
										   					   final AA14BookedSlotType slotType);
	/**
	 * Finds slots in a date range
	 * @param securityContext
	 * @param locationOid
	 * @param dateRange
	 * @return
	 */
	public FindResult<AA14BookedSlot> findRangeBookedSlotsFor(final SecurityContext securityContext,
										   					  final AA14OrgDivisionServiceLocationOID locationOid,
										   					  final Range<Date> dateRange);
	/**
	 * Finds slots in a date range
	 * @param securityContext
	 * @param locationOid
	 * @param dateRange
	 * @return
	 */
	public FindSummariesResult<AA14BookedSlot> findRangeBookedSlotsSummarizedFor(final SecurityContext securityContext,
																				 final Language lang,
																  				 final AA14OrgDivisionServiceLocationOID locationOid,
																  				 final Range<Date> dateRange);
/////////////////////////////////////////////////////////////////////////////////////////
//  RANGE BOOKED SLOTS BY SERVICE LOCATION & SCHEDULE
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Finds slots in a date range
	 * @param securityContext
	 * @param locationOid
	 * @param range
	 * @return
	 */
	public FindResult<AA14BookedSlot> findRangeBookedSlotsFor(final SecurityContext securityContext,
										   					  final AA14OrgDivisionServiceLocationOID locationOid,final AA14ScheduleOID schOid,
										   					  final Range<Date> range);
	/**
	 * Finds slots in a date range
	 * @param securityContext
	 * @param locationOid
	 * @param dateRange
	 * @return
	 */
	public FindSummariesResult<AA14BookedSlot> findRangeBookedSlotsSummarizedFor(final SecurityContext securityContext,
																				 final Language lang,
																  				 final AA14OrgDivisionServiceLocationOID locationOid,final AA14ScheduleOID schOid,
																  				 final Range<Date> dateRange);
/////////////////////////////////////////////////////////////////////////////////////////
//	OVERLAPPING BOOKED SLOTS 
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Finds slots overlapping a given range
	 * <pre>
	 * [1] |-------------------------------------------|
	 * [2] |-----------|
	 * [3]                |------------|
 	 * [4]                                 |-----------|
	 *          [===============================]
	 * </pre>
	 * @param securityContext
	 * @param schOid
	 * @param dateRange
	 * @return
	 */
	public FindResult<AA14BookedSlot> findBookedSlotsOverlappingRange(final SecurityContext securityContext,
																	  final AA14ScheduleOID schOid,
																	  final Range<Date> dateRange);
/////////////////////////////////////////////////////////////////////////////////////////
//  FIND APPOINTMENTS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Returns summaries for all active slots for a person 
	 * @param securityContext
	 * @param lang
	 * @param personId
	 * @return
	 */
	public FindSummariesResult<AA14Appointment> findAppointmentsByCustomerId(final SecurityContext securityContext,
																 		     final Language lang,
																 		     final PersonID personId);
	
	/**
	 * Returns the slots for the provided subject (ie exp code)
	 * (usually it'll return a single result)
	 * @param securityContext
	 * @param lang
	 * @param subjectId
	 * @return
	 */
	public FindSummariesResult<AA14Appointment> findAppointmentsBySubjectId(final SecurityContext securityContext,
																		    final Language lang,
																		    final AA14AppointmentSubjectID subjectId);
	/**
	 * Returns summaries for all active slots within a certain service for a person 
	 * @param securityContext
	 * @param lang
	 * @param serviceId
	 * @param personId
	 * @return
	 */
	public FindSummariesResult<AA14Appointment> findAppointmentsByCustomerIdForService(final SecurityContext securityContext,
																		   			   final Language lang,
																		   			   final AA14OrgDivisionServiceID serviceId,
																		   			   final PersonID personId);
	
	/**
	 * Returns the slots within a certain service for the provided subject (ie exp code) 
	 * (usually it'll return a single result)
	 * @param securityContext
	 * @param lang
	 * @param serviceId
	 * @param subjectId
	 * @return
	 */
	public FindSummariesResult<AA14Appointment> findAppointmentsBySubjectIdForService(final SecurityContext securityContext,
																					  final Language lang,
																					  final AA14OrgDivisionServiceID serviceId,
																					  final AA14AppointmentSubjectID subjectId);
	/**
	 * Returns summaries for all active slots within a certain service for a person 
	 * @param securityContext
	 * @param lang
	 * @param serviceLocationId
	 * @param personId
	 * @return
	 */
	public FindSummariesResult<AA14Appointment> findAppointmentsByCustomerIdForServiceLocation(final SecurityContext securityContext,
																		   			   		   final Language lang,
																		   			   		   final AA14OrgDivisionServiceLocationID serviceLocationId,
																		   			   		   final PersonID personId);
	
	/**
	 * Returns the slots within a certain service for the provided subject (ie exp code) 
	 * (usually it'll return a single result)
	 * @param securityContext
	 * @param lang
	 * @param serviceLocationId
	 * @param subjectId
	 * @return
	 */
	public FindSummariesResult<AA14Appointment> findAppointmentsBySubjectIdForServiceLocation(final SecurityContext securityContext,
																					  		  final Language lang,
																					  		  final AA14OrgDivisionServiceLocationID serviceLocationId,
																					  		  final AA14AppointmentSubjectID subjectId);
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Finds alls periodic non-bookable slots (all them are related by the serieOid)
	 * @param securityContext
	 * @param serieOid
	 * @return
	 */
	public FindOIDsResult<AA14SlotOID> findNonBookablePeriodicSlotsOids(final SecurityContext securityContext,
																	    final AA14PeriodicSlotSerieOID serieOid);
	/**
	 * Finds alls periodic non-bookable slots (all them are related by the serieOid)
	 * @param securityContext
	 * @param serieOid
	 * @return
	 */
	public FindResult<AA14NonBookableSlot> findNonBookablePeriodicSlots(final SecurityContext securityContext,
																	    final AA14PeriodicSlotSerieOID serieOid);	
}