package aa14f.api.interfaces;

import java.util.Collection;

import aa14f.model.AA14Schedule;
import aa14f.model.oids.AA14IDs.AA14ScheduleID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14ScheduleOID;
import r01f.model.persistence.CRUDResult;
import r01f.securitycontext.SecurityContext;
import r01f.services.interfaces.ExposedServiceInterface;

@ExposedServiceInterface
public interface AA14CRUDServicesForSchedule
         extends AA14CRUDServicesBase<AA14ScheduleOID,AA14ScheduleID,AA14Schedule> {

	/**
	 * Links an schedule to certain locations
	 * Creates the schedule to service location [many to many] relation
	 * <pre>
	 *          |  SRVC LOC 1   |   SRVC LOC 2    |   SRVC LOC 3
	 *          |===============|=================|================
	 *    SCH 1 |       X       |                 |               
	 *    SCH 2 |               |       X         |      X
	 *    SCH 3 |       X       |       X         |      X
	 * </pre>
	 * @param securityContext
	 * @param schOid
	 * @param locOids
	 * @return
	 */
	public CRUDResult<AA14Schedule> linkScheduleToServiceLocations(SecurityContext securityContext,
																   AA14ScheduleOID schOid,	
															 	   Collection<AA14OrgDivisionServiceLocationOID> locOids);
} 