package aa14b.services.delegates.persistence;

import javax.persistence.EntityManager;

import com.google.common.eventbus.EventBus;

import aa14b.db.find.AA14DBFindForSchedule;
import aa14f.api.interfaces.AA14FindServicesForSchedule;
import aa14f.model.AA14Schedule;
import aa14f.model.oids.AA14IDs.AA14ScheduleID;
import aa14f.model.oids.AA14OIDs.AA14ScheduleOID;
import r01f.bootstrap.services.config.core.ServicesCoreBootstrapConfigWhenBeanExposed;
import r01f.objectstreamer.Marshaller;
import r01f.persistence.db.config.DBModuleConfigBuilder;

/**
 * Service layer delegated type for CRUD (Create/Read/Update/Delete) operations
 */
public class AA14FindServicesDelegateForSchedule
	 extends AA14FindServicesDelegateBase<AA14ScheduleOID,AA14ScheduleID,AA14Schedule>
  implements AA14FindServicesForSchedule {

/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14FindServicesDelegateForSchedule(final ServicesCoreBootstrapConfigWhenBeanExposed coreCfg,
											   final EntityManager entityManager,
											   final Marshaller marshaller,
				  			   		   	   	   final EventBus eventBus) {
		super(coreCfg,
			  AA14Schedule.class,
			  new AA14DBFindForSchedule(DBModuleConfigBuilder.dbModuleConfigFrom(coreCfg),
					  					entityManager,
					  			  		marshaller));
	}
}
