package aa14b.services.delegates.notifier;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

import aa14f.model.AA14NotificationOperation;
import aa14f.model.summaries.AA14SummarizedAppointment;
import r01f.locale.Language;
import r01f.types.contact.EMail;
import r01f.types.contact.Phone;
import r01f.util.types.Dates;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;
import r01f.util.types.locale.Languages;

abstract class AA14NotifierTemplateModelDataSupplierBase
  	implements AA14NotifierTemplateModelDataSupplier {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTS
/////////////////////////////////////////////////////////////////////////////////////////
	protected static final String DAY_FORMAT= "yyyyMMdd";
	protected static final String HOUR_FORMAT= "hhmmss";

	protected static String[] DAY_OF_WEEK_ES = {"Domingo","Lunes","Martes", "Mircoles","Jueves","Viernes","Sbado"};
	protected static String[] DAY_OF_WEEK_EU = {"Igandea","Astelehena","Asteartea", "Asteazkena","Osteguna","Ostirala","Larunbata"};
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////
	protected static String _dayOfWeekName(final Date d,
										   final Language lang) {
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(d);
		return lang == Language.BASQUE ? DAY_OF_WEEK_EU[cal.get(Calendar.DAY_OF_WEEK) - 1]
									   : DAY_OF_WEEK_ES[cal.get(Calendar.DAY_OF_WEEK) - 1];	
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public Map<String,Object> supplyModelDataForCreate(final AA14SummarizedAppointment appointment,
												  	   final Language lang,
												  	   final Collection<EMail> mails,final Collection<Phone> phones) {
	    Map<String,Object> model = _supplyCommonModelData(AA14NotificationOperation.CREATE,
	    												  appointment,
	    												  lang,
	    												  mails,phones);
    	return model;
	}
	@Override
	public Map<String,Object> supplyModelDataForUpdate(final AA14SummarizedAppointment appointment,
													   final Language lang,
													   final Collection<EMail> mails,final Collection<Phone> phones) {
	    Map<String,Object> model = _supplyCommonModelData(AA14NotificationOperation.UPDATE,
	    												  appointment,
	    												  lang,
	    												  mails,phones);
    	return model;
	}
	@Override
	public Map<String,Object> supplyModelDataForDelete(final AA14SummarizedAppointment appointment,
													   final Language lang,
													   final Collection<EMail> mails,final Collection<Phone> phones) {
	    Map<String,Object> model = _supplyCommonModelData(AA14NotificationOperation.DELETE,
	    												  appointment,
	    												  lang,
	    												  mails,phones);
	    return model;
	}
	@Override
	public Map<String, Object> supplyModelDataForRemindTomorrow(final AA14SummarizedAppointment appointment, 
																final Language lang,
																final Collection<EMail> mails,final  Collection<Phone> phones) {
	    Map<String,Object> model = _supplyCommonModelData(AA14NotificationOperation.REMIND_TOMORROW,
	    												  appointment,
	    												  lang,
	    												  mails,phones);
	    return model;
	}
	@Override
	public Map<String, Object> supplyModelDataForRemindToday(final AA14SummarizedAppointment appointment, 
															 final Language lang,
															 final Collection<EMail> mails,final Collection<Phone> phones) {
	    Map<String,Object> model = _supplyCommonModelData(AA14NotificationOperation.REMIND_TODAY,
	    												  appointment,
	    												  lang,
	    												  mails,phones);
	    return model;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	 
/////////////////////////////////////////////////////////////////////////////////////////
	protected Map<String,Object> _supplyCommonModelData(final AA14NotificationOperation op,
														final AA14SummarizedAppointment appointment,
													    final Language lang,
													    final Collection<EMail> mails,final Collection<Phone> phones) {
		Map<String,Object> model = new HashMap<String,Object>();
	    
	    // Header
		model.put("serviceLbl",(lang == Language.BASQUE ? "HITZORDUA ESKATZEA" 
														: "SERVICIO DE CITA PREVIA"));
	    model.put("serviceName",appointment.getService().getName());
	    if (op.is(AA14NotificationOperation.DELETE)) {
		    model.put("operation",lang == Language.BASQUE ? "HITZORDU EZEZTATUTA" 
		    											  : "CITA CANCELADA");
	    } else {
	    	model.put("operation","");
	    }
	    

	    model.put("appointmentDate",_dayOfWeekName(appointment.getStartDate(),lang) + " " + appointment.getStartDateFormatted(lang));
	    model.put("appointmentTime",Strings.customized("{}:{}",
	    											   appointment.getStartTime().getHourOfDay(),appointment.getStartTime().getMinuteOfHour()));
	    
	    model.put("appointmentId",appointment.getId().asString());
	    
    	model.put("appointmentOrg",appointment.getOrganization().getName());
    	model.put("appointmentDiv",appointment.getDivision().getName());
    	model.put("appointmentService",appointment.getService().getName());
    	model.put("appointmentLoc",appointment.getLocation().getName());
    	
    	model.put("appointmentStartDay",Dates.format(appointment.getStartDate(),DAY_FORMAT));
    	model.put("appointmentStartHour",Dates.format(appointment.getStartDate(),HOUR_FORMAT));
    	model.put("appointmentEndDay",Dates.format(appointment.getEndDate(),DAY_FORMAT));
    	model.put("appointmentEndHour",Dates.format(appointment.getEndDate(),HOUR_FORMAT));
    	
    	// Location data
	    model.put("textLocationData",lang == Language.BASQUE ? "Hitzordu-lekua" : "Lugar de la cita");

	    model.put("textDepartamento",lang == Language.BASQUE ? "Saila" : "Departamento");
    	model.put("valDepartamento",Strings.customized("{} - {}",
    													appointment.getOrganization().getName(),
    													appointment.getDivision().getName()));

    	model.put("textServicio",lang == Language.BASQUE ? "Zerbitzua" : "Servicio");
    	model.put("valServicio",appointment.getService().getName());
	    
    	model.put("textTerritorio",lang == Language.BASQUE ? "Lurraldea" : "Territorio Histrico");
		model.put("appointmentValTerritorio",appointment.getLocation().getTerritory());
		
	    model.put("textTramite",lang == Language.BASQUE ? "Izapidea" : "Trmite");
    	model.put("valTramite",appointment.getService().getProcedure() != null ? appointment.getService().getProcedure() : "");
	    
    	model.put("textDireccion",lang == Language.BASQUE ? "Helbidea" : "Direccin");
    	model.put("appointmentValDireccion",appointment.getLocation().getStreet());
		
    	model.put("textPoblacion",lang == Language.BASQUE ? "Herria" : "Poblacin");
    	model.put("appointmentValPoblacion",appointment.getLocation().getMunicipality());
	    
    	model.put("textProvincia",lang == Language.BASQUE ? "Probintzia" : "Provincia");
    	model.put("appointmentValProvincia",appointment.getLocation().getState());
	    
    	model.put("textTelefono",lang == Language.BASQUE ? "Telefonoa" : "Telfono");
    	model.put("appointmentValTelefono",appointment.getLocation().getPhone());
    	
    	// Personal data
	    model.put("textPersonalData",lang == Language.BASQUE ? "Harremanetarako datuak" : "Datos personales");
	    model.put("textDNI",lang == Language.BASQUE ? "NAN/IFZ/Pasaportea" : "DNI/NIF/Pasaporte");
    	model.put("appointmentDNI",appointment.getPerson().getId().asString());
	    model.put("textName",lang == Language.BASQUE ? "Izena" : "Nombre");
    	model.put("appointmentName",appointment.getPerson().getName());
	    model.put("textSurName",lang == Language.BASQUE ? "Abizenak" : "Apellidos");
    	model.put("appointmentSurName",appointment.getPerson().getSurname());
    	
    	// details
	    model.put("textDetails",lang == Language.BASQUE ? "Xehetasunak" : "Detalles");
	    if (appointment.getSubject() != null) {
	    	if (appointment.getSubject().getId() != null && !appointment.getSubject().getId().getRaw().equals("-")) {
	    		model.put("textAppointmentExpID",lang == Language.BASQUE ? "Espediente-zenbakia" : "Nmero de expediente");
	    		model.put("appointmentExpID",appointment.getSubject().getId());
	    	}
	    	if (Strings.isNOTNullOrEmpty(appointment.getSubject().getDescription())) {
	    		model.put("appointmentExpDescription",appointment.getSubject().getDescription());
	    	}
	    }
	    
    	// contact info
	    model.put("textPhone",lang == Language.BASQUE ? "Telefono" : "Telfono");
    	String lstPhones = CollectionUtils.of(phones).toStringCommaSeparated();
    	model.put("appointmentPhone",lstPhones);
	    model.put("textEmail",lang == Language.BASQUE ? "Helbide elektronikoa" : "Correo electrnico");
    	model.put("appointmentEmail",mails);
    	
    	// Footer
    	model.put("includeCancelFooter",op.isIn(AA14NotificationOperation.CREATE,
    										    AA14NotificationOperation.UPDATE) ? true : false);
    	model.put("textCancel",lang == Language.BASQUE ? "Hartu duzun hitzordua baliogabetu egin nahi baduzu:" 
    													: "Si desea  anular su cita previa:");
    	model.put("cancelZuzeneanPhone",lang == Language.BASQUE ? "deitu 012 (94501800) telefono-zenbakira"
    															: "llame al tel&eacute;fono 012 (94501800)");
    	model.put("cancelZuzeneanLocation",lang == Language.BASQUE ? "jo Zuzeneanen arreta-bulego batera"
    															   : "acuda a una oficina de atencin de Zuzenean");
    	model.put("cancelZuzeneanWeb",lang == Language.BASQUE ? "jo Zuzeneanen web"
    														  : "vaya a la web");
    	
    	// URL Zuzenean
    	model.put("zuzeneanLocList",lang == Language.BASQUE ? "lurraldea" : "ver delegaciones");
    	String urlLocZuzenean = Strings.customized("http://www.zuzenean.euskadi.eus/s68-conpres/{}/contenidos/informacion/zuzenean_atencion_presencial/{}_atencion/oficinas.html",
    											    Languages.countryLowerCase(lang),Languages.countryLowerCase(lang));
    	model.put("urlLocZuzenean",urlLocZuzenean);

    	String urlWebZuzenean = lang == Language.BASQUE ? "http://www.zuzenean.euskadi.eus/hitzorduaeskatzea"
    													: "http://www.zuzenean.euskadi.eus/citaprevia";
    	model.put("urlWebZuzenean",urlWebZuzenean);
    	return model;
	}
}
