package aa14b.services.delegates.notifier;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.apache.velocity.app.VelocityEngine;
import org.springframework.ui.velocity.VelocityEngineUtils;

import com.twilio.sdk.TwilioRestException;

import aa14b.core.config.notifier.AA14ConfigForTwilioNotifier;
import aa14f.model.AA14NotificationMessage;
import aa14f.model.AA14NotificationOperation;
import aa14f.model.summaries.AA14SummarizedAppointment;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import r01f.internal.R01F;
import r01f.locale.Language;
import r01f.twilio.TwilioService;
import r01f.types.Path;
import r01f.types.contact.Phone;
import r01f.types.url.Url;

/**
 * A notifier that just logs the message
 */
@Singleton
@Slf4j
public class AA14NotifierServicesVoiceImpl
     extends AA14NotifierServicesDelegateImplBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////
	@Getter private final TwilioService _twilioService;
	
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14NotifierServicesVoiceImpl(final AA14ConfigForTwilioNotifier config,
										 final TwilioService twilioService,
										 final VelocityEngine templateEngine) {
		super(config,
			  templateEngine,
			  new AA14NotifierTemplateSelectorVoiceImpl(config));
		_twilioService = twilioService;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public void sendNotification(final AA14NotificationOperation op,
								 final AA14NotificationMessage message) {
		boolean isEnabled = _config.isEnabled() & _twilioService.isEnabled();
		if (isEnabled) {
			log.info("==============>SEND APPOINTMENT NOTIFICATION BY VOICE (twilio)");
			if (message.getPhonesSanitized() != null) {
				try {
					for (Phone phone : message.getPhonesSanitized()) {
						Phone intPhone = Phone.of(phone.asStringEnsuringCountryCode("+34"));	// ensure the phone contains +34
						log.warn("\t--> sending voice message to {}",intPhone);
						Url twmlUrl = Url.from("https://dl.dropboxusercontent.com/u/1264561/testTwilioTWML.xml");
						_twilioService.makeCall(intPhone,
												twmlUrl);
					}
				} catch (TwilioRestException restEx) {
					restEx.printStackTrace(System.out);
				}
			} else {
				log.warn("\t--> there arent phones to send message...");
			}
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	private static String _composeVoiceMessage(final VelocityEngine velocityEngine,final Path alertMsgTemplatePath,
											   final AA14SummarizedAppointment appointment) {
		Language lang = appointment.getPerson().getPreferredLang() != null ? appointment.getPerson().getPreferredLang()
																		   : Language.DEFAULT;
	    // Text... using velocity
	    Map<String,Object> model = new HashMap<String,Object>();
    	model.put("appointmentDate",appointment.getStartDateFormatted(lang));
	    model.put("appointmentId",appointment.getId());
	    String text = VelocityEngineUtils.mergeTemplateIntoString(velocityEngine,alertMsgTemplatePath.asRelativeString(),
	    														  R01F.DEFAULT_CHARSET.name(),
	    														  model);
	    return text;
	}
}
