package aa14b.services.delegates.notifier;

import aa14f.client.api.AA14ConfigForBizilagun;
import aa14f.client.api.AA14ConfigForBloodDonation;
import aa14f.client.api.AA14ConfigForTrafikoa;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14IDs.AA14OrganizationID;
import r01f.locale.Language;

/**
 * Selects the {@link AA14NotifierTemplateModelDataSupplier} using some model data
 */
public class AA14NotifierDataSupplierSelector {
	/**
	 * Returns the {@link AA14NotifierTemplateModelDataSupplier} to be used
	 * @param org
	 * @param div
	 * @param srvc
	 * @param loc
	 * @param lang
	 * @return
	 */
	public AA14NotifierTemplateModelDataSupplier dataSupplierFor(final AA14OrganizationID org,final AA14OrgDivisionID div,final AA14OrgDivisionServiceID srvc,final AA14OrgDivisionServiceLocationID loc,
									  							 final Language lang) {
		AA14NotifierTemplateModelDataSupplier outSupplier = null;
		if (srvc.is(AA14ConfigForTrafikoa.SERVICE_ID)) {
			outSupplier = new AA14NotifierTemplateModelDataSupplierForTrafikoa();
		}
		else if (srvc.isContainedIn(AA14ConfigForBizilagun.SERVICE_COMUNIDADES_ALQUILERES_ID,
						   			AA14ConfigForBizilagun.SERVICE_FIANZAS_DEPOSITO_CONTRATOS_ID)) {
			outSupplier = new AA14NotifierTemplateModelDataSupplierForBizilagun();
		}
		else if (srvc.is(AA14ConfigForBloodDonation.SERVICE_ID)) {
			outSupplier = new AA14NotifierTemplateModelDataSupplierForDonations();
		}
		else {
			throw new IllegalArgumentException("The given service " + srvc + " is NOT one of the supported ones: " + 
										       AA14ConfigForTrafikoa.SERVICE_ID + ", " + 
										       AA14ConfigForBizilagun.SERVICE_COMUNIDADES_ALQUILERES_ID + ", " + 
										       AA14ConfigForBizilagun.SERVICE_FIANZAS_DEPOSITO_CONTRATOS_ID + ", "+
										       AA14ConfigForBloodDonation.SERVICE_ID);
		}
		return outSupplier;
	}
}
