/**
 *
 */
package aa14b.notifier.scheduler.quartz;

import java.util.Date;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.PersistJobDataAfterExecution;

import aa14f.api.interfaces.AA14CRUDServicesForBookedSlot;
import aa14f.api.interfaces.AA14FindServicesForBookedSlot;
import aa14f.api.interfaces.AA14NotifierServices;
import aa14f.model.AA14NotificationOperation;
import lombok.experimental.Accessors;
import r01f.types.Range;
import r01fb.scheduler.QuartzSchedulerJobFactory;
import r01fb.scheduler.SchedulerConfig;

/**
 * Quartz Job executed by the quartz scheduler when a trigger is raised
 * The executer is created each time the quartz scheduler executes the job
 * 
 * BEWARE!!!                                                                                  
 * 		In order for this instance to be injected by guice it MUST be created by guice             
 * 		... so use a job factory : {@link QuartzSchedulerJobFactory}                                           
 * 		(see http://javaeenotes.blogspot.com.es/2011/09/inject-instances-in-quartz-jobs-with.html) 
 */
@PersistJobDataAfterExecution   
@DisallowConcurrentExecution    // the job instance does NOT allow concurrency (it's not thread safe) 
@Accessors(prefix="_")
public class AA14NotifierQuartzSchedulerJobForRemindTomorrow 
     extends AA14NotifierQuartzSchedulerJobBase {	
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14NotifierQuartzSchedulerJobForRemindTomorrow(final SchedulerConfig cfg,
										  				   final AA14FindServicesForBookedSlot bookedSlotsFindServices,
										  				   final AA14CRUDServicesForBookedSlot bookedSlotsCRUDServices,
										  				   final AA14NotifierServices notifierServices) {
		super(cfg,
			  bookedSlotsFindServices,
			  bookedSlotsCRUDServices,
			  notifierServices,
			  AA14NotificationOperation.REMIND_TOMORROW);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	protected Range<Date> _slotFilterRangeIf(final Date prevFireTime,final Date nextFireTime) {
		// TODO get the correct date range
		Date lowerDate = prevFireTime != null ? prevFireTime : new Date();
		Date upperDate = nextFireTime != null ? nextFireTime : new Date();
		return Range.closed(lowerDate,upperDate);
	}
}