package aa14b.db.search;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;

import com.google.inject.Provider;

import aa14f.model.search.AA14SearchFilter;
import aa14f.model.search.AA14SearchResultItem;
import lombok.experimental.Accessors;
import r01f.model.annotations.ModelObjectsMarshaller;
import r01f.objectstreamer.Marshaller;
import r01f.persistence.db.config.DBModuleConfig;
import r01f.persistence.search.Searcher;
import r01f.persistence.search.db.DBSearcherProviderBase;

@Singleton
@Accessors(prefix="_")
public class AA14DBSearcherProvider
     extends DBSearcherProviderBase<AA14SearchFilter,AA14SearchResultItem> {
/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////	
	@Inject
	public AA14DBSearcherProvider(						   final DBModuleConfig dbModuleConfig,
														   final Provider<EntityManager> entityManagerProvider,
								   @ModelObjectsMarshaller final Marshaller marshaller) {
		super(dbModuleConfig,
			  entityManagerProvider,
			  marshaller);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  Provider
/////////////////////////////////////////////////////////////////////////////////////////	
	@Override
	public Searcher<AA14SearchFilter,AA14SearchResultItem> get() {
		return new AA14DBSearcherForEntityModelObject(_dbModuleConfig,
													  _entityManagerProvider.get(),
													  _marshaller);
	}
}