package aa14b.db.entities;

import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;


@Entity @Cacheable(false)
@Table(name="AA14APPOINTMENTT00")

@DiscriminatorValue("APPOINTMENT")

@NamedQueries({	
	// Find all customer's appointments
	@NamedQuery(name = "AA14DBEntitiesForAppointmentsByCustomer",
				query = "SELECT app " +
						  "FROM AA14DBEntityForAppointment app " +
						 "WHERE app._startDate >= :dayStart " +
						   "AND UPPER(app._personId) = UPPER(:personId)"),
	// Find all appointments by subject id (cod exp)
	@NamedQuery(name = "AA14DBEntitiesForAppointmentsBySubjectId",
				query = "SELECT app " +
						  "FROM AA14DBEntityForAppointment app " +
						 "WHERE app._startDate >= :dayStart " +
						   "AND app._subjectId = :subjectId"),
	// Find all customer's appointments
	@NamedQuery(name = "AA14DBEntitiesForAppointmentsForServiceByCustomer",
				query = "SELECT app " +
						  "FROM AA14DBEntityForAppointment app " +
						 "WHERE app._startDate >= :dayStart " +
						   "AND app._orgDivisionServiceId = :serviceId " +
						   "AND UPPER(app._personId) = UPPER(:personId)"),
	// Find all appointments by subject id (cod exp)
	@NamedQuery(name = "AA14DBEntitiesForAppointmentsForServiceBySubjectId",
				query = "SELECT app " +
						  "FROM AA14DBEntityForAppointment app " +
						 "WHERE app._startDate >= :dayStart " +
						   "AND app._orgDivisionServiceId = :serviceId " +
						   "AND app._subjectId = :subjectId"),
	// Find all customer's appointments
	@NamedQuery(name = "AA14DBEntitiesForAppointmentsForServiceLocationByCustomer",
				query = "SELECT app " +
						  "FROM AA14DBEntityForAppointment app " +
						 "WHERE app._startDate >= :dayStart " +
						   "AND app._orgDivisionServiceLocationId = :locId " +
						   "AND UPPER(app._personId) = UPPER(:personId)"),
	// Find all appointments by subject id (cod exp)
	@NamedQuery(name = "AA14DBEntitiesForAppointmentsForServiceLocationBySubjectId",
				query = "SELECT app " +
						  "FROM AA14DBEntityForAppointment app " +
						 "WHERE app._startDate >= :dayStart " +
						   "AND app._orgDivisionServiceLocationId = :locId " +
						   "AND app._subjectId = :subjectId")
})

@Accessors(prefix="_")
@NoArgsConstructor
public class AA14DBEntityForAppointment
     extends AA14DBEntityForBookedSlotBase {

	private static final long serialVersionUID = 7697152902080922348L;

/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////
	@Column(name="PERSON_ID",length=15,nullable=false) @Basic
	@Getter @Setter protected String _personId;

	@Column(name="PERSON_SUMMARY",length=200,nullable=false) @Basic
	@Getter @Setter protected String _personSummary;
	
	@Column(name="SUBJECT_ID",length=200,nullable=false) @Basic
	@Getter @Setter protected String _subjectId;
}
