package aa14b.core.config.notifier;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.twilio.TwilioConfig;
import r01f.types.url.Url;
import r01f.xmlproperties.XMLPropertiesForAppComponent;

@Accessors(prefix="_")
public class AA14ConfigForTwilioNotifier 
	 extends AA14ConfigForNotifierBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////
	@Getter private final TwilioConfig _twilioConfig;
	@Getter private final Url _twmlUrl;
	
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14ConfigForTwilioNotifier(final boolean enabled,final boolean simulated,
									   final TwilioConfig twilioNotifierConfig,
									   final Url twmUrl) {
		super(enabled,simulated);
		_twilioConfig = twilioNotifierConfig;
		_twmlUrl = twmUrl;
	}
	public static AA14ConfigForTwilioNotifier createFrom(final XMLPropertiesForAppComponent xmlProps) {
		boolean enabled = _isEnabled(xmlProps, 
									 AA14NotifierType.TWILIO);
		boolean simulated = _isSimulated(xmlProps, 
									 	 AA14NotifierType.TWILIO);
		TwilioConfig twilioConfig = TwilioConfig.createFrom(xmlProps,
															"notifier");
		Url twmlUrl = xmlProps.propertyAt("/notifier/notifiers/voice/twmlUrl")
									.asUrl(Url.from("http://demo.twilio.com/docs/voice.xml"));
		return new AA14ConfigForTwilioNotifier(enabled,simulated,
											   twilioConfig,	
											   twmlUrl);
	}	
}
