package aa14b.core.config.notifier;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.config.ContainsConfigData;
import r01f.xmlproperties.XMLPropertiesForAppComponent;

@Accessors(prefix="_")
public abstract class AA14ConfigForNotifierBase 
    	   implements ContainsConfigData {
/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////
	@Getter protected final boolean _enabled;
	@Getter protected final boolean _simulated;
	
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14ConfigForNotifierBase(final boolean enabled,final boolean simulated) {
		_enabled = enabled;
		_simulated = simulated;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	@SuppressWarnings("unchecked")
	public <C extends AA14ConfigForNotifierBase> C as(final Class<C> type) {
		return (C)this;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	enum AA14NotifierType {
		MAIL,
		LATINIA,
		TWILIO,
		LOG;
	}
	protected static boolean _isEnabled(final XMLPropertiesForAppComponent xmlProps,
								 		final AA14NotifierType notifierType) {
		String name = _nameFor(notifierType);
		return xmlProps.propertyAt("/notifier/notifiers/" + name + "/@enabled").asBoolean(true);
	}
	protected static boolean _isSimulated(final XMLPropertiesForAppComponent xmlProps,
								   		  final AA14NotifierType notifierType) {
		String name = _nameFor(notifierType);
		return xmlProps.propertyAt("/notifier/notifiers/" + name + "/@simulated").asBoolean(false);
	}
	private static String _nameFor(final AA14NotifierType notifierType) {
		String name = null;
		if (notifierType == AA14NotifierType.MAIL) {
			name = "mail";
		} else if (notifierType == AA14NotifierType.LATINIA) {
			name = "messaging";
		} else if (notifierType == AA14NotifierType.TWILIO) {
			name = "voice";
		} else if (notifierType == AA14NotifierType.LOG) {
			name = "log";
		} else {
			throw new IllegalArgumentException("Unknown notifier type: " + notifierType);
		}
		return name;
	}
}
