package aa14b.core.config.notifier;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.mail.config.JavaMailSenderConfig;
import r01f.mail.config.JavaMailSenderConfigBuilder;
import r01f.types.contact.EMail;
import r01f.xmlproperties.XMLPropertiesForAppComponent;

@Accessors(prefix="_")
public class AA14ConfigForMailNotifier 
	 extends AA14ConfigForNotifierBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////
	@Getter private final JavaMailSenderConfig _mailSenderConfig;
	@Getter private final EMail _from;
	
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14ConfigForMailNotifier(final boolean enabled,final boolean simulated,	
									 final JavaMailSenderConfig mailSenderConfig,
									 final EMail from) {
		super(enabled,simulated);
		_mailSenderConfig = mailSenderConfig;
		_from = from;
	}
	public static AA14ConfigForMailNotifier createFrom(final XMLPropertiesForAppComponent xmlProps) {
		boolean enabled = _isEnabled(xmlProps,
									 AA14NotifierType.MAIL);
		boolean simulated = _isSimulated(xmlProps,
									 	 AA14NotifierType.MAIL);
		JavaMailSenderConfig mailSenderConfig = JavaMailSenderConfigBuilder.createFrom(xmlProps,
	   															   					   "notifier");
		EMail from = xmlProps.propertyAt("/notifier/notifiers/mail/from")
								.asEMail("Zuzenean-No-Reply@euskadi.eus");
		return new AA14ConfigForMailNotifier(enabled,simulated,
											 mailSenderConfig,
											 from);
	}	
}
