package aa14b.core.config.notifier;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.services.latinia.LatiniaServiceAPIData;
import r01f.xmlproperties.XMLPropertiesForAppComponent;

@Accessors(prefix="_")
public class AA14ConfigForLatiniaNotifier 
	 extends AA14ConfigForNotifierBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////
	@Getter private final LatiniaServiceAPIData _latiniaConfig;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14ConfigForLatiniaNotifier(final boolean enabled,final boolean simulated,
										final LatiniaServiceAPIData latiniaNotifierConfig) {
		super(enabled,
			  simulated);
		_latiniaConfig = latiniaNotifierConfig;
	}
	public static AA14ConfigForLatiniaNotifier createFrom(final XMLPropertiesForAppComponent xmlProps) {
		boolean enabled = _isEnabled(xmlProps, 
									 AA14NotifierType.LOG);
		boolean simulated = _isSimulated(xmlProps, 
									 	 AA14NotifierType.LOG);
		LatiniaServiceAPIData latiniaNotifierConfig = LatiniaServiceAPIData.createFrom(xmlProps,
	   																   				   "notifier");
		return new AA14ConfigForLatiniaNotifier(enabled,simulated,
												latiniaNotifierConfig);
	}	
}
