package aa14b.calendar;

import r01f.model.persistence.PersistenceErrorType;
import r01f.model.persistence.PersistenceException;
import r01f.model.persistence.PersistenceRequestedOperation;

public class AA14CalendarServiceException 
	 extends PersistenceException {

	private static final long serialVersionUID = 3245897076136608704L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTS
/////////////////////////////////////////////////////////////////////////////////////////
	public static final int SLOT_OCCUPIED_EXT_ERROR_CODE = 1;
	public static final int GENERAL_ERROR_CODE = 99;
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	AA14CalendarServiceException(final PersistenceRequestedOperation requestedOp,
											final String msg,
											final PersistenceErrorType errorType,final int extendedCode) {
		super(requestedOp,requestedOp.name(),
			  msg,
			  errorType,extendedCode);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	public boolean wasBecauseSlotIsOccupied() {
		return this.getPersistenceErrorType()
				   .is(PersistenceErrorType.ENTITY_ALREADY_EXISTS)
			&& this.getExtendedCode() == 1;		// calendar appointment already exists
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  STATIC BUILDERS
/////////////////////////////////////////////////////////////////////////////////////////
	public static AA14CalendarServiceException createForAppointmentSlotOccupied() {
		return new AA14CalendarServiceException(PersistenceRequestedOperation.CREATE,
														   "The appointment slot is occupied",
														   PersistenceErrorType.ENTITY_ALREADY_EXISTS,SLOT_OCCUPIED_EXT_ERROR_CODE);// slot is occupied 
	}
	public static AA14CalendarServiceException createForCalendarUnavailable(final PersistenceRequestedOperation reqOp) {
		return new AA14CalendarServiceException(reqOp,
														   "Calendar service is unavailable",
														   PersistenceErrorType.CLIENT_CANNOT_CONNECT_SERVER,GENERAL_ERROR_CODE);	// general error
	}
}
