package aa14b.bootstrap.core;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;

import aa14b.core.config.notifier.AA14ConfigForLatiniaNotifier;
import aa14b.core.config.notifier.AA14ConfigForLogNotifier;
import aa14b.core.config.notifier.AA14ConfigForMailNotifier;
import aa14b.core.config.notifier.AA14ConfigForNotifierScheduler;
import aa14b.core.config.notifier.AA14ConfigForTwilioNotifier;
import aa14b.events.AA14CRUDOKEventListenersForNotificationEvents.AA14CRUDOKEventListenersForAppointmentLog;
import aa14b.events.AA14CRUDOKEventListenersForNotificationEvents.AA14CRUDOKEventListenersForAppointmentNotifyByEMail;
import aa14b.events.AA14CRUDOKEventListenersForNotificationEvents.AA14CRUDOKEventListenersForAppointmentNotifyByMessaging;
import aa14b.services.internal.AA14BookedSlotSummarizerService;
import aa14b.services.internal.AA14SlotOverlappingValidatorService;
import lombok.EqualsAndHashCode;
import r01f.bootstrap.BeanImplementedPersistenceServicesCoreBootstrapGuiceModuleBase;
import r01f.bootstrap.ServicesBootstrapGuiceModuleBindsCRUDEventListeners;
import r01f.bootstrap.services.config.core.ServicesCoreBootstrapConfigWhenBeanExposed;
import r01f.guids.CommonOIDs.AppComponent;
import r01f.inject.HasMoreBindings;
import r01f.persistence.db.config.DBModuleConfigBuilder;
import r01f.persistence.search.config.SearchModuleConfigBuilder;


@EqualsAndHashCode(callSuper=true)				// This is important for guice modules
public class AA14ServicesBootstrapGuiceModule
     extends BeanImplementedPersistenceServicesCoreBootstrapGuiceModuleBase
  implements ServicesBootstrapGuiceModuleBindsCRUDEventListeners,
  			 HasMoreBindings {
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14ServicesBootstrapGuiceModule(final ServicesCoreBootstrapConfigWhenBeanExposed coreBootstrapCfg) {
		super(coreBootstrapCfg,
			  new AA14DBGuiceModule(DBModuleConfigBuilder.dbModuleConfigFrom(coreBootstrapCfg)),
			  new AA14SearchGuiceModule(SearchModuleConfigBuilder.searchModuleConfigFrom(coreBootstrapCfg)),
			  new Module[] {
					new AA14NotifierGuiceModule(// notifier scheduler
												coreBootstrapCfg.<AA14ConfigForNotifierScheduler>getSubModuleConfigFor(AppComponent.forId("notifier.scheduler")),
												// notifiers
												coreBootstrapCfg.<AA14ConfigForMailNotifier>getSubModuleConfigFor(AppComponent.forId("notifier.mail")),
												coreBootstrapCfg.<AA14ConfigForLatiniaNotifier>getSubModuleConfigFor(AppComponent.forId("notifier.latinia")),
												coreBootstrapCfg.<AA14ConfigForTwilioNotifier>getSubModuleConfigFor(AppComponent.forId("notifier.twilio")),
												coreBootstrapCfg.<AA14ConfigForLogNotifier>getSubModuleConfigFor(AppComponent.forId("notifier.logger"))),
					new AA14CalendarGuiceModule()
			  });
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public void configureMoreBindings(final Binder binder) {
		// booked slots summarizer 
		binder.bind(AA14BookedSlotSummarizerService.class)
			  .in(Singleton.class);
		
		// slot overlapping validator
		binder.bind(AA14SlotOverlappingValidatorService.class)
			  .in(Singleton.class);
		
	}
	@Override
	public void bindCRUDEventListeners(final Binder binder) {
		// Bind notifiers event listeners
		// ... messaging (latinia)
		binder.bind(AA14CRUDOKEventListenersForAppointmentNotifyByMessaging.class)
			  .asEagerSingleton();
		// ... mail
		binder.bind(AA14CRUDOKEventListenersForAppointmentNotifyByEMail.class)
			  .asEagerSingleton();
		// ... log
		binder.bind(AA14CRUDOKEventListenersForAppointmentLog.class)
			  .asEagerSingleton();
	}
}
