package aa14b.bootstrap.core;

import aa14b.core.config.notifier.AA14ConfigForLatiniaNotifier;
import aa14b.core.config.notifier.AA14ConfigForLogNotifier;
import aa14b.core.config.notifier.AA14ConfigForMailNotifier;
import aa14b.core.config.notifier.AA14ConfigForNotifierScheduler;
import aa14b.core.config.notifier.AA14ConfigForTwilioNotifier;
import aa14b.services.AA14ServiceInterfaceImpl;
import aa14f.common.internal.AA14AppCodes;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import r01f.bootstrap.services.config.core.ServicesCoreBootstrapConfigBuilder;
import r01f.bootstrap.services.config.core.ServicesCoreBootstrapConfigWhenBeanExposed;
import r01f.bootstrap.services.config.core.ServicesCoreSubModuleBootstrapConfig;
import r01f.guids.CommonOIDs.AppComponent;
import r01f.patterns.IsBuilder;
import r01f.services.ids.ServiceIDs.CoreModule;
import r01f.xmlproperties.XMLPropertiesForApp;
import r01f.xmlproperties.XMLPropertiesForAppComponent;

/**
 * Builds bootstrap confif
 */
@NoArgsConstructor(access=AccessLevel.PRIVATE)
public abstract class AA14BeanServicesBootstrapConfigBuilder
		   implements IsBuilder {
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	public static ServicesCoreBootstrapConfigWhenBeanExposed buildCoreBootstrapConfig(final XMLPropertiesForApp xmlProps) {
		XMLPropertiesForAppComponent dbXmlProps = xmlProps.forComponent(AppComponent.compose(AA14AppCodes.CORE_APPOINTMENTS_MOD,
																							 CoreModule.DBPERSISTENCE));
		XMLPropertiesForAppComponent notifierXmlProps = xmlProps.forComponent(AppComponent.compose(AA14AppCodes.CORE_APPOINTMENTS_MOD,
																							 	   CoreModule.NOTIFIER));
		return ServicesCoreBootstrapConfigBuilder.forCoreAppAndModule(AA14AppCodes.CORE_APPCODE,AA14AppCodes.CORE_APPOINTMENTS_MOD)
	   				.beanImplemented()
	   					.bootstrappedBy(AA14ServicesBootstrapGuiceModule.class)
	   					.findServicesExtending(AA14ServiceInterfaceImpl.class)
	   					.withSubModulesConfigs(
	   							// db config
	   							ServicesCoreSubModuleBootstrapConfig.createForDBPersistenceSubModule(AA14DBModuleConfig.dbConfigFor(dbXmlProps)),
	   							
	   							////////// Notifier
	   							// notifier scheduler
	   							new ServicesCoreSubModuleBootstrapConfig<AA14ConfigForNotifierScheduler>(AppComponent.forId("notifier.scheduler"),
	   																						 	    	 AA14ConfigForNotifierScheduler.createFrom(notifierXmlProps)),
	   							
	   							// - mail notifier
	   							new ServicesCoreSubModuleBootstrapConfig<AA14ConfigForMailNotifier>(AppComponent.forId("notifier.mail"),
	   																						 	    AA14ConfigForMailNotifier.createFrom(notifierXmlProps)),
	   							// - latinia notifier
	   							new ServicesCoreSubModuleBootstrapConfig<AA14ConfigForLatiniaNotifier>(AppComponent.forId("notifier.latinia"),
	   																			 	  				   AA14ConfigForLatiniaNotifier.createFrom(notifierXmlProps)),
	   							// - twilio notifier
	   							new ServicesCoreSubModuleBootstrapConfig<AA14ConfigForTwilioNotifier>(AppComponent.forId("notifier.twilio"),
	   																			 	 				  AA14ConfigForTwilioNotifier.createFrom(notifierXmlProps)),
	   							// - logger notifier
	   							new ServicesCoreSubModuleBootstrapConfig<AA14ConfigForLogNotifier>(AppComponent.forId("notifier.logger"),
	   																			 	 			   AA14ConfigForLogNotifier.createFrom(notifierXmlProps)) 
	   					).build();
	}
}
