package aa14b.rest.resources.delegates;

import java.net.URI;

import javax.ws.rs.core.Response;

import aa14f.api.interfaces.AA14FindServicesForOrganization;
import aa14f.model.AA14Organization;
import aa14f.model.oids.AA14IDs.AA14OrganizationID;
import aa14f.model.oids.AA14OIDs.AA14OrganizationOID;
import aa14f.server.rest.resources.delegates.AA14RESTFindDelegateBaseForOrganizationalEntity;
import r01f.locale.Language;
import r01f.model.persistence.FindSummariesResult;
import r01f.rest.RESTOperationsResponseBuilder;
import r01f.securitycontext.SecurityContext;

public class AA14RESTFindDelegateForOrganization
	 extends AA14RESTFindDelegateBaseForOrganizationalEntity<AA14OrganizationOID,AA14OrganizationID,AA14Organization> {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTFindDelegateForOrganization(final AA14FindServicesForOrganization findServices) {
		super(AA14Organization.class,
			  findServices);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	EXTENSION METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	public Response findSummaries(final SecurityContext securityContext,final String resourcePath,
								  final Language lang) {
		FindSummariesResult<AA14Organization> findResult = this.getFindServicesAs(AA14FindServicesForOrganization.class)
															   .findSummaries(securityContext,
																			  lang);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
}
