package aa14b.rest.resources.delegates;

import java.net.URI;

import javax.ws.rs.core.Response;

import aa14f.api.interfaces.AA14FindServicesForOrgDivisionServiceLocation;
import aa14f.model.AA14OrgDivisionServiceLocation;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import aa14f.server.rest.resources.delegates.AA14RESTFindDelegateBaseForOrganizationalEntity;
import r01f.locale.Language;
import r01f.model.persistence.FindResult;
import r01f.model.persistence.FindSummariesResult;
import r01f.rest.RESTOperationsResponseBuilder;
import r01f.securitycontext.SecurityContext;

public class AA14RESTFindDelegateForOrgDivisionServiceLocation
	 extends AA14RESTFindDelegateBaseForOrganizationalEntity<AA14OrgDivisionServiceLocationOID,AA14OrgDivisionServiceLocationID,AA14OrgDivisionServiceLocation> {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTFindDelegateForOrgDivisionServiceLocation(final AA14FindServicesForOrgDivisionServiceLocation findServices) {
		super(AA14OrgDivisionServiceLocation.class,
			  findServices);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	public Response findByOrgDivisionService(final SecurityContext securityContext,final String resourcePath,
			  					   	  		 final AA14OrgDivisionServiceOID serviceOid) {
		FindResult<AA14OrgDivisionServiceLocation> findResult = this.getFindServicesAs(AA14FindServicesForOrgDivisionServiceLocation.class)
																		.findByOrgDivisionService(securityContext,
																						   		 serviceOid);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
	public Response findSummariesByOrgDivisionService(final SecurityContext securityContext,final String resourcePath,
											   		  final AA14OrgDivisionServiceOID serviceOid,
											   		  final Language lang) {
		FindSummariesResult<AA14OrgDivisionServiceLocation> findResult = this.getFindServicesAs(AA14FindServicesForOrgDivisionServiceLocation.class)
																			   .findSummariesByOrgDivisionService(securityContext,
																							  			   		  serviceOid,lang);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
}
