package aa14b.rest.resources.delegates;

import java.net.URI;

import javax.ws.rs.core.Response;

import aa14f.api.interfaces.AA14FindServicesForOrgDivisionService;
import aa14f.model.AA14OrgDivisionService;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import aa14f.server.rest.resources.delegates.AA14RESTFindDelegateBaseForOrganizationalEntity;
import r01f.locale.Language;
import r01f.model.persistence.FindResult;
import r01f.model.persistence.FindSummariesResult;
import r01f.rest.RESTOperationsResponseBuilder;
import r01f.securitycontext.SecurityContext;

public class AA14RESTFindDelegateForOrgDivisionService
	 extends AA14RESTFindDelegateBaseForOrganizationalEntity<AA14OrgDivisionServiceOID,AA14OrgDivisionServiceID,AA14OrgDivisionService> {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTFindDelegateForOrgDivisionService(final AA14FindServicesForOrgDivisionService findServices) {
		super(AA14OrgDivisionService.class,
			  findServices);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	public Response findByOrgDivision(final SecurityContext securityContext,final String resourcePath,
			  					   	  final AA14OrgDivisionOID divisionOid) {
		FindResult<AA14OrgDivisionService> findResult = this.getFindServicesAs(AA14FindServicesForOrgDivisionService.class)
																.findByOrgDivision(securityContext,
																				   divisionOid);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
	public Response findSummariesByOrgDivision(final SecurityContext securityContext,final String resourcePath,
											   final AA14OrgDivisionOID divisionOid,
								  			   final Language lang) {
		FindSummariesResult<AA14OrgDivisionService> findResult = this.getFindServicesAs(AA14FindServicesForOrgDivisionService.class)
																		   .findSummariesByOrgDivision(securityContext,
																						  			   divisionOid,lang);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
}
