package aa14b.rest.resources.delegates;

import java.net.URI;

import javax.ws.rs.core.Response;

import aa14f.api.interfaces.AA14FindServicesForOrgDivision;
import aa14f.model.AA14OrgDivision;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionOID;
import aa14f.model.oids.AA14OIDs.AA14OrganizationOID;
import aa14f.server.rest.resources.delegates.AA14RESTFindDelegateBaseForOrganizationalEntity;
import r01f.locale.Language;
import r01f.model.persistence.FindResult;
import r01f.model.persistence.FindSummariesResult;
import r01f.rest.RESTOperationsResponseBuilder;
import r01f.securitycontext.SecurityContext;

public class AA14RESTFindDelegateForOrgDivision
	 extends AA14RESTFindDelegateBaseForOrganizationalEntity<AA14OrgDivisionOID,AA14OrgDivisionID,AA14OrgDivision> {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTFindDelegateForOrgDivision(final AA14FindServicesForOrgDivision findServices) {
		super(AA14OrgDivision.class,
			  findServices);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	public Response findByOrganization(final SecurityContext securityContext,final String resourcePath,
			  					   	   final AA14OrganizationOID orgOid) {
		FindResult<AA14OrgDivision> findResult = this.getFindServicesAs(AA14FindServicesForOrgDivision.class)
													 .findByOrganization(securityContext,
																		 orgOid);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
	public Response findSummariesByOrganization(final SecurityContext securityContext,final String resourcePath,
												final AA14OrganizationOID orgOid,
								  				final Language lang) {
		FindSummariesResult<AA14OrgDivision> findResult = this.getFindServicesAs(AA14FindServicesForOrgDivision.class)
															   .findSummariesByOrganization(securityContext,
																			  			    orgOid,lang);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
}
