package aa14b.rest.resources.delegates;

import java.net.URI;
import java.util.Date;

import javax.ws.rs.core.Response;

import aa14f.api.interfaces.AA14FindServicesForBookedSlot;
import aa14f.model.AA14Appointment;
import aa14f.model.AA14BookedSlot;
import aa14f.model.oids.AA14IDs.AA14SlotID;
import aa14f.model.oids.AA14OIDs.AA14AppointmentSubjectID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14SlotOID;
import aa14f.server.rest.resources.delegates.AA14RESTFindDelegateBaseForEntity;
import r01f.locale.Language;
import r01f.model.persistence.FindResult;
import r01f.model.persistence.FindSummariesResult;
import r01f.rest.RESTOperationsResponseBuilder;
import r01f.securitycontext.SecurityContext;
import r01f.types.Range;
import r01f.types.contact.PersonID;

public class AA14RESTFindDelegateForBookedSlot
	 extends AA14RESTFindDelegateBaseForEntity<AA14SlotOID,AA14SlotID,AA14BookedSlot> {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTFindDelegateForBookedSlot(final AA14FindServicesForBookedSlot findServices) {
		super(AA14BookedSlot.class,
			  findServices);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	EXTENSION METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	public Response findRangeAppointmentsFor(final SecurityContext securityContext,final String resourcePath,
											 final AA14OrgDivisionServiceLocationOID locationOid,
			  								 final Range<Date> dateRange) {
		FindResult<AA14BookedSlot> findResult = this.getFindServicesAs(AA14FindServicesForBookedSlot.class)
													 .findRangeBookedSlotsFor(securityContext,
															 				  locationOid, 
															 				  dateRange);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
	public Response findRangeAppointmentsSummarizedFor(final SecurityContext securityContext,final String resourcePath,
													   final Language lang,
												   	   final AA14OrgDivisionServiceLocationOID locationOid,
												   	   final Range<Date> dateRange) {
		FindSummariesResult<AA14BookedSlot> findResult = this.getFindServicesAs(AA14FindServicesForBookedSlot.class)
															 .findRangeBookedSlotsSummarizedFor(securityContext,
																	 							lang,
																	 						    locationOid, 
																	 						    dateRange);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
	public Response findByCustomerID(final SecurityContext securityContext,final String resourcePath,
									 final Language lang,
									 final PersonID personId) {
		FindSummariesResult<AA14Appointment> findResult = this.getFindServicesAs(AA14FindServicesForBookedSlot.class)
													 		  .findAppointmentsByCustomerId(securityContext,
													 				  		    			lang,
													 				  		    			personId);
		return RESTOperationsResponseBuilder.findOn(AA14Appointment.class)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
	public Response findByAppointmentSubjectId(final SecurityContext securityContext,final String resourcePath,
											   final Language lang,
											   final AA14AppointmentSubjectID subjectId) {
		FindSummariesResult<AA14Appointment> findResult = this.getFindServicesAs(AA14FindServicesForBookedSlot.class)
														 		  .findAppointmentsBySubjectId(securityContext,
														 				  					   lang,
														 				  					   subjectId);
		return RESTOperationsResponseBuilder.findOn(AA14Appointment.class)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
}
