package aa14b.rest.resources.delegates;

import java.net.URI;

import javax.ws.rs.core.Response;

import aa14f.api.interfaces.AA14BookedSlotsCalendarServices;
import aa14f.model.AA14Appointment;
import aa14f.model.AA14NumberOfAdjacentSlots;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14ScheduleOID;
import aa14f.model.timeslots.AA14DayRangeTimeSlots;
import r01f.rest.RESTOperationsResponseBuilder;
import r01f.rest.resources.delegates.RESTDelegateForModelObjectBase;
import r01f.securitycontext.SecurityContext;
import r01f.types.datetime.DayOfMonth;
import r01f.types.datetime.MonthOfYear;
import r01f.types.datetime.Year;

public class AA14RESTDelegateForAppointmentsCalendar
	 extends RESTDelegateForModelObjectBase<AA14Appointment> {
/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////
	private final AA14BookedSlotsCalendarServices _calendarServices;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTDelegateForAppointmentsCalendar(final AA14BookedSlotsCalendarServices calendarServices) {
		super(AA14Appointment.class);
		_calendarServices = calendarServices;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	public Response availableTimeSlotsForRange(final SecurityContext securityContext,final String resourcePath,
									  		   final AA14OrgDivisionServiceLocationOID locOid,final AA14ScheduleOID prefSchOid,
									  		   final AA14NumberOfAdjacentSlots numberOfAdjacentSlots,
									  		   final Year year,final MonthOfYear monthOfYear,final DayOfMonth dayOfMonth,
									  		   final int numberOfDays,
									  		   final boolean slipDateRangeToFindFirstAvailableSlot) {
		AA14DayRangeTimeSlots availableSlots = _calendarServices.availableTimeSlotsForRange(securityContext,
																							locOid,prefSchOid,
																							numberOfAdjacentSlots,
																							year,monthOfYear,dayOfMonth,
																							numberOfDays,
																							slipDateRangeToFindFirstAvailableSlot);
		return RESTOperationsResponseBuilder.executed()
											.at(URI.create(resourcePath))
											.build(availableSlots);
	}
	public Response availableTimeSlotsForRange(final SecurityContext securityContext,final String resourcePath,
									  		   final AA14ScheduleOID schOid,final AA14OrgDivisionServiceLocationOID prefLocOid,
									  		   final AA14NumberOfAdjacentSlots numberOfAdjacentSlots,
									  		   final Year year,final MonthOfYear monthOfYear,final DayOfMonth dayOfMonth,
									  		   final int numberOfDays,
									  		   final boolean slipDateRangeToFindFirstAvailableSlot) {
		AA14DayRangeTimeSlots availableSlots = _calendarServices.availableTimeSlotsForRange(securityContext,
																							schOid,prefLocOid,
																							numberOfAdjacentSlots,
																							year,monthOfYear,dayOfMonth,
																							numberOfDays,
																							slipDateRangeToFindFirstAvailableSlot);
		return RESTOperationsResponseBuilder.executed()
											.at(URI.create(resourcePath))
											.build(availableSlots);
	}
}
