package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Path;

import aa14b.rest.resources.delegates.AA14RESTSearchDelegate;
import aa14f.api.interfaces.AA14SearchServices;
import aa14f.model.search.AA14SearchFilter;
import aa14f.model.search.AA14SearchResultItem;
import aa14f.server.rest.resources.AA14RESTResourceForSearchBase;
import lombok.experimental.Accessors;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically 
 * the section about the methods (GET, PUT, POST, DELETE...)
 * 
 * Log: see web.xml
 */
@Path("index")
@Singleton
@Accessors(prefix="_")
public class AA14RESTSearchResource 
	 extends AA14RESTResourceForSearchBase<AA14SearchFilter,AA14SearchResultItem> {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTSearchResource(final AA14SearchServices searchServices) {
		super(new AA14RESTSearchDelegate(searchServices));
	}
}
