package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.joda.time.LocalDate;

import aa14b.rest.resources.delegates.AA14RESTDelegateForAppointmentsCalendar;
import aa14f.api.context.AA14SecurityContext;
import aa14f.api.interfaces.AA14BookedSlotsCalendarServices;
import aa14f.model.AA14NumberOfAdjacentSlots;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14ScheduleOID;
import lombok.experimental.Accessors;
import r01f.rest.RESTResourceBase;
import r01f.types.datetime.DayOfMonth;
import r01f.types.datetime.MonthOfYear;
import r01f.types.datetime.Year;
import r01f.util.types.Dates;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("appointments/calendar")
@Singleton
@Accessors(prefix="_")
public class AA14RESTResourceForAppointmentsCalendar
	 extends RESTResourceBase {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTResourceForAppointmentsCalendar(final AA14BookedSlotsCalendarServices calendarServices) {
		super(new AA14RESTDelegateForAppointmentsCalendar(calendarServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	@GET @Path("/byLocation/{locOid}/{date}/timeSlots")	// would be better if summarized were a param BUT it cannot be done this way: conflict with findAll
	@Produces(MediaType.APPLICATION_XML)
	public Response timeSlotsForRange(@HeaderParam("securityContext")		final AA14SecurityContext securityContext,
									  @PathParam("locOid")			    	final AA14OrgDivisionServiceLocationOID locOid,@QueryParam("prefSchOid") final AA14ScheduleOID prefSchOid,
									  @QueryParam("numberOfAdjacentSlots") 	final int numberOfAdjacentSlots,
									  @PathParam("date")			    	final String dateStr,
									  @QueryParam("numberOfDays")	    	final int numberOfDays,
									  @QueryParam("slipDateRangeToFindFirstAvailableSlot") final boolean slipDateRangeToFindFirstAvailableSlot) {
		LocalDate date = new LocalDate(Dates.fromFormatedString(dateStr,"yyyy-MM-dd"));
		int theNumberOfDays = numberOfDays <= 0 ? 5 : numberOfDays;
		int theNumberOfAdjacentSlots = numberOfAdjacentSlots <= 0 ? 1 : numberOfAdjacentSlots; 
		return this.getDelegateAs(AA14RESTDelegateForAppointmentsCalendar.class)
						.availableTimeSlotsForRange(securityContext,_req.getPathInfo(),
									   	   			locOid,prefSchOid,
									   	   			AA14NumberOfAdjacentSlots.fromCode(theNumberOfAdjacentSlots),
									   	   			Year.of(date),MonthOfYear.of(date),DayOfMonth.of(date),
									   	   			theNumberOfDays,
									   	   			slipDateRangeToFindFirstAvailableSlot);
	}
	@GET @Path("/bySchedule/{schOid}/{date}/timeSlots")	// would be better if summarized were a param BUT it cannot be done this way: conflict with findAll
	@Produces(MediaType.APPLICATION_XML)
	public Response timeSlotsForRange(@HeaderParam("securityContext")		final AA14SecurityContext securityContext,
									  @PathParam("schOid")			    	final AA14ScheduleOID schOid,@QueryParam("prefLocOid") AA14OrgDivisionServiceLocationOID prefLocOid,
									  @QueryParam("numberOfAdjacentSlots")  final int numberOfAdjacentSlots,
									  @PathParam("date")			    	final String dateStr,
									  @QueryParam("numberOfDays")	    	final int numberOfDays,
									  @QueryParam("slipDateRangeToFindFirstAvailableSlot") final boolean slipDateRangeToFindFirstAvailableSlot) {
		LocalDate date = new LocalDate(Dates.fromFormatedString(dateStr,"yyyy-MM-dd"));
		int theNumberOfDays = numberOfDays <= 0 ? 5 : numberOfDays;
		int theNumberOfAdjacentSlots = numberOfAdjacentSlots <= 0 ? 1 : numberOfAdjacentSlots;
		return this.getDelegateAs(AA14RESTDelegateForAppointmentsCalendar.class)
						.availableTimeSlotsForRange(securityContext,_req.getPathInfo(),
									   	   			schOid,prefLocOid,
									   	   			AA14NumberOfAdjacentSlots.fromCode(theNumberOfAdjacentSlots),
									   	   			Year.of(date),MonthOfYear.of(date),DayOfMonth.of(date),
									   	   			theNumberOfDays,
									   	   			slipDateRangeToFindFirstAvailableSlot);
	}
}
