package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14b.rest.resources.delegates.AA14RESTFindDelegateForOrganization;
import aa14f.api.context.AA14SecurityContext;
import aa14f.api.interfaces.AA14FindServicesForOrganization;
import aa14f.model.AA14Organization;
import aa14f.model.oids.AA14IDs.AA14OrganizationID;
import aa14f.model.oids.AA14OIDs.AA14OrganizationOID;
import aa14f.server.rest.resources.AA14RESTFindResourceBaseForOrganizationalEntity;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01f.model.persistence.PersistenceException;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("organizations/list")
@Singleton
@Accessors(prefix="_")
public class AA14RESTFindResourceForOrganization
	 extends AA14RESTFindResourceBaseForOrganizationalEntity<AA14OrganizationOID,AA14OrganizationID,AA14Organization> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTFindResourceForOrganization(final AA14FindServicesForOrganization findServices) {
		super(new AA14RESTFindDelegateForOrganization(findServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	@GET @Path("summarized")	// would be better if summarized were a param BUT it cannot be done this way: conflict with findAll
	@Produces(MediaType.APPLICATION_XML)
	public Response findSummaries(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
							 	  @QueryParam("lang")			    final Language lang) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForOrganization.class)
						.findSummaries(securityContext,_req.getPathInfo(),
									   lang);
	}
}
