package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14b.rest.resources.delegates.AA14RESTFindDelegateForOrgDivisionServiceLocation;
import aa14f.api.context.AA14SecurityContext;
import aa14f.api.interfaces.AA14FindServicesForOrgDivisionServiceLocation;
import aa14f.model.AA14OrgDivisionServiceLocation;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import aa14f.server.rest.resources.AA14RESTFindResourceBaseForOrganizationalEntity;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01f.model.persistence.PersistenceException;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("locations/list")
@Singleton
@Accessors(prefix="_")
public class AA14RESTFindResourceForOrgDivisionServiceLocation
	 extends AA14RESTFindResourceBaseForOrganizationalEntity<AA14OrgDivisionServiceLocationOID,AA14OrgDivisionServiceLocationID,AA14OrgDivisionServiceLocation> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTFindResourceForOrgDivisionServiceLocation(final AA14FindServicesForOrgDivisionServiceLocation findServices) {
		super(new AA14RESTFindDelegateForOrgDivisionServiceLocation(findServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FIND
/////////////////////////////////////////////////////////////////////////////////////////
	@GET @Path("byService/{srvcOid}")
	@Produces(MediaType.APPLICATION_XML)
	public Response findByOrgDivisionService(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
							 	   	  		 @PathParam("srvcOid")  		    final AA14OrgDivisionServiceOID serviceOid) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForOrgDivisionServiceLocation.class)
						.findByOrgDivisionService(securityContext,_req.getPathInfo(),
									       		  serviceOid);
	}
	@GET @Path("byService/{srvcOid}/summarized")	// would be better if summarized were a param BUT it cannot be done this way: conflict with findAll
	@Produces(MediaType.APPLICATION_XML)
	public Response findSummariesByOrgDivisionService(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
											   		  @PathParam("srvcOid")  		    final AA14OrgDivisionServiceOID serviceOid,
											   		  @QueryParam("lang")			    final Language lang) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForOrgDivisionServiceLocation.class)
						.findSummariesByOrgDivisionService(securityContext,_req.getPathInfo(),
									   			 		   serviceOid,lang);
	}
}
