package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14b.rest.resources.delegates.AA14RESTFindDelegateForOrgDivisionService;
import aa14f.api.context.AA14SecurityContext;
import aa14f.api.interfaces.AA14FindServicesForOrgDivisionService;
import aa14f.model.AA14OrgDivisionService;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionOID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import aa14f.server.rest.resources.AA14RESTFindResourceBaseForOrganizationalEntity;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01f.model.persistence.PersistenceException;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("services/list")
@Singleton
@Accessors(prefix="_")
public class AA14RESTFindResourceForOrgDivisionService
	 extends AA14RESTFindResourceBaseForOrganizationalEntity<AA14OrgDivisionServiceOID,AA14OrgDivisionServiceID,AA14OrgDivisionService> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTFindResourceForOrgDivisionService(final AA14FindServicesForOrgDivisionService findServices) {
		super(new AA14RESTFindDelegateForOrgDivisionService(findServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FIND
/////////////////////////////////////////////////////////////////////////////////////////
	@GET @Path("byDivision/{divOid}")
	@Produces(MediaType.APPLICATION_XML)
	public Response findByOrgDivision(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
							 	   	  @PathParam("divOid")  		    final AA14OrgDivisionOID divisionOid) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForOrgDivisionService.class)
						.findByOrgDivision(securityContext,_req.getPathInfo(),
									       divisionOid);
	}
	@GET @Path("byDivision/{divOid}/summarized")	// would be better if summarized were a param BUT it cannot be done this way: conflict with findAll
	@Produces(MediaType.APPLICATION_XML)
	public Response findSummariesByOrgDivision(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
											   @PathParam("divOid")  		    final AA14OrgDivisionOID divisionOid,
							 	  			   @QueryParam("lang")			    final Language lang) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForOrgDivisionService.class)
						.findSummariesByOrgDivision(securityContext,_req.getPathInfo(),
									   			    divisionOid,lang);
	}
}
