package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14b.rest.resources.delegates.AA14RESTFindDelegateForOrgDivision;
import aa14f.api.context.AA14SecurityContext;
import aa14f.api.interfaces.AA14FindServicesForOrgDivision;
import aa14f.model.AA14OrgDivision;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionOID;
import aa14f.model.oids.AA14OIDs.AA14OrganizationOID;
import aa14f.server.rest.resources.AA14RESTFindResourceBaseForOrganizationalEntity;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01f.model.persistence.PersistenceException;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("divisions/list")
@Singleton
@Accessors(prefix="_")
public class AA14RESTFindResourceForOrgDivision
	 extends AA14RESTFindResourceBaseForOrganizationalEntity<AA14OrgDivisionOID,AA14OrgDivisionID,AA14OrgDivision> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTFindResourceForOrgDivision(final AA14FindServicesForOrgDivision findServices) {
		super(new AA14RESTFindDelegateForOrgDivision(findServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FIND
/////////////////////////////////////////////////////////////////////////////////////////
	@GET @Path("byOrganization/{orgOid}")
	@Produces(MediaType.APPLICATION_XML)
	public Response findByOrganization(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
							 	       @PathParam("orgOid")  		    final AA14OrganizationOID orgOid) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForOrgDivision.class)
						.findByOrganization(securityContext,_req.getPathInfo(),
									        orgOid);
	}
	@GET @Path("byOrganization/{orgOid}/summarized")	// would be better if summarized were a param BUT it cannot be done this way: conflict with findAll
	@Produces(MediaType.APPLICATION_XML)
	public Response findSummariesByOrganization(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
												@PathParam("orgOid")  		    final AA14OrganizationOID orgOid,
							 	  				@QueryParam("lang")			    final Language lang) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForOrgDivision.class)
						.findSummariesByOrganization(securityContext,_req.getPathInfo(),
									   				 orgOid,lang);
	}
}
