package aa14b.rest.resources;

import java.util.Date;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14b.rest.resources.delegates.AA14RESTFindDelegateForBookedSlot;
import aa14f.api.context.AA14SecurityContext;
import aa14f.api.interfaces.AA14FindServicesForBookedSlot;
import aa14f.model.AA14BookedSlot;
import aa14f.model.oids.AA14IDs.AA14SlotID;
import aa14f.model.oids.AA14OIDs.AA14AppointmentSubjectID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.model.oids.AA14OIDs.AA14SlotOID;
import aa14f.server.rest.resources.AA14RESTFindResourceBaseForEntity;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01f.model.persistence.PersistenceException;
import r01f.rest.RESTDateRangeParam;
import r01f.types.Range;
import r01f.types.contact.NIFPersonID;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("appointments/list")
@Singleton
@Accessors(prefix="_")
public class AA14RESTFindResourceForBookdeSlot
	 extends AA14RESTFindResourceBaseForEntity<AA14SlotOID,AA14SlotID,AA14BookedSlot> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTFindResourceForBookdeSlot(final AA14FindServicesForBookedSlot findServices) {
		super(new AA14RESTFindDelegateForBookedSlot(findServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	@GET @Path("byLocation/{locOid}")	
	@Produces(MediaType.APPLICATION_XML)
	public Response findDayAppointmentsFor(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
							 	  		   @PathParam("locOid")			    final AA14OrgDivisionServiceLocationOID locOid,
							 	  		   @QueryParam("dateRange") 	    final RESTDateRangeParam dateRange,
							 	  		   @QueryParam("lang")			    final Language lang,
							 	  		   @QueryParam("summarized") 	    final boolean summarized) throws PersistenceException {
		Range<Date> theDateRange = dateRange != null ? dateRange.asDateRange() : null;
		if (summarized) {
			return this.getDelegateAs(AA14RESTFindDelegateForBookedSlot.class)
							.findRangeAppointmentsSummarizedFor(securityContext,_req.getPathInfo(),
																lang,
										   				    	locOid,
										   				    	theDateRange);
		} 
		return this.getDelegateAs(AA14RESTFindDelegateForBookedSlot.class)
						.findRangeAppointmentsFor(securityContext,_req.getPathInfo(),
									   			  locOid,
									   			  theDateRange);
	}
	@GET @Path("byCustomerId/{personId}")	
	@Produces(MediaType.APPLICATION_XML)
	public Response findByCustomerId(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
							 	     @PathParam("personId")			    final NIFPersonID personId,
							 	     @QueryParam("lang")			    final Language lang,
							 	  	 @QueryParam("summarized") 		    final boolean summarized) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForBookedSlot.class)
						.findByCustomerID(securityContext,_req.getPathInfo(),
										  lang,
									   	  personId);
	}
	@GET @Path("bySubjectId/{subjectId}")	
	@Produces(MediaType.APPLICATION_XML)
	public Response findByAppointmentSubjectId(@HeaderParam("securityContext")	final AA14SecurityContext securityContext,
							 	    		   @PathParam("subjectId")		    final AA14AppointmentSubjectID subjectId,
							 	    		   @QueryParam("lang")			    final Language lang,
							 	    		   @QueryParam("summarized") 	    final boolean summarized) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateForBookedSlot.class)
						.findByAppointmentSubjectId(securityContext,_req.getPathInfo(),
													lang,
									   	  			subjectId);
	}
}
