package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Path;

import aa14b.rest.resources.delegates.AA14RESTCRUDDelegateForOrganization;
import aa14f.api.interfaces.AA14CRUDServicesForOrganization;
import aa14f.model.AA14Organization;
import aa14f.model.oids.AA14IDs.AA14OrganizationID;
import aa14f.model.oids.AA14OIDs.AA14OrganizationOID;
import aa14f.server.rest.resources.AA14RESTCRUDResourceBaseForOrganizationalEntity;
import lombok.experimental.Accessors;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("organizations")
@Singleton
@Accessors(prefix="_")
public class AA14RESTCRUDResourceForOrganization
	 extends AA14RESTCRUDResourceBaseForOrganizationalEntity<AA14OrganizationOID,AA14OrganizationID,AA14Organization> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTCRUDResourceForOrganization(final AA14CRUDServicesForOrganization crudServices) {
		super(new AA14RESTCRUDDelegateForOrganization(crudServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
}
