package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Path;

import aa14b.rest.resources.delegates.AA14RESTCRUDDelegateForOrgDivisionServiceLocation;
import aa14f.api.interfaces.AA14CRUDServicesForOrgDivisionServiceLocation;
import aa14f.model.AA14OrgDivisionServiceLocation;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceLocationOID;
import aa14f.server.rest.resources.AA14RESTCRUDResourceBaseForOrganizationalEntity;
import lombok.experimental.Accessors;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("locations")
@Singleton
@Accessors(prefix="_")
public class AA14RESTCRUDResourceForOrgDivisionServiceLocation
	 extends AA14RESTCRUDResourceBaseForOrganizationalEntity<AA14OrgDivisionServiceLocationOID,AA14OrgDivisionServiceLocationID,AA14OrgDivisionServiceLocation> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTCRUDResourceForOrgDivisionServiceLocation(final AA14CRUDServicesForOrgDivisionServiceLocation crudServices) {
		super(new AA14RESTCRUDDelegateForOrgDivisionServiceLocation(crudServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  EXTENSIONS
/////////////////////////////////////////////////////////////////////////////////////////	

	
}
