package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Path;

import aa14b.rest.resources.delegates.AA14RESTCRUDDelegateForOrgDivisionService;
import aa14f.api.interfaces.AA14CRUDServicesForOrgDivisionService;
import aa14f.model.AA14OrgDivisionService;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14OIDs.AA14OrgDivisionServiceOID;
import aa14f.server.rest.resources.AA14RESTCRUDResourceBaseForOrganizationalEntity;
import lombok.experimental.Accessors;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path("services")
@Singleton
@Accessors(prefix="_")
public class AA14RESTCRUDResourceForOrgDivisionService
	 extends AA14RESTCRUDResourceBaseForOrganizationalEntity<AA14OrgDivisionServiceOID,AA14OrgDivisionServiceID,AA14OrgDivisionService> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTCRUDResourceForOrgDivisionService(final AA14CRUDServicesForOrgDivisionService crudServices) {
		super(new AA14RESTCRUDDelegateForOrgDivisionService(crudServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  EXTENSIONS
/////////////////////////////////////////////////////////////////////////////////////////	

	
}
