package aa14b.rest.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Path;

import aa14b.rest.resources.delegates.AA14RESTCRUDDelegateForBookedSlot;
import aa14f.api.interfaces.AA14CRUDServicesForBookedSlot;
import aa14f.common.internal.AA14AppCodes;
import aa14f.model.AA14BookedSlot;
import aa14f.model.oids.AA14IDs.AA14SlotID;
import aa14f.model.oids.AA14OIDs.AA14SlotOID;
import aa14f.server.rest.resources.AA14RESTCRUDResourceBaseForEntity;
import lombok.experimental.Accessors;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Path(AA14AppCodes.APPOINTMENTS_MODULE_STR)
@Singleton
@Accessors(prefix="_")
public class AA14RESTCRUDResourceForBookedSlot
	 extends AA14RESTCRUDResourceBaseForEntity<AA14SlotOID,AA14SlotID,AA14BookedSlot> {
/////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	@Inject
	public AA14RESTCRUDResourceForBookedSlot(final AA14CRUDServicesForBookedSlot crudServices) {
		super(new AA14RESTCRUDDelegateForBookedSlot(crudServices));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
}
