package aa14b.bootstrap.rest;


import com.google.inject.Binder;

import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;
import r01f.bootstrap.services.config.core.ServicesCoreGuiceBootstrapConfigWhenRESTExposed;
import r01f.bootstrap.services.core.RESTImplementedServicesCoreBootstrapGuiceModuleBase;


@Slf4j
@EqualsAndHashCode(callSuper=true)		// This is important for guice modules
public class AA14RESTServicesBootstrapGuiceModule
     extends RESTImplementedServicesCoreBootstrapGuiceModuleBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTServicesBootstrapGuiceModule(final ServicesCoreGuiceBootstrapConfigWhenRESTExposed coreModuleCfg) {
		super(coreModuleCfg);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	BINDER
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public void configure(final Binder binder) {
		log.warn("START____________ AA14 ServiceRequests REST Bootstraping _____________________________");

		binder.install(new AA14RESTJerseyServletGuiceModule());				// Servlet Modules for GUICE-Jersey
		binder.install(new AA14RESTResourcesGuiceModule());		// REST Resource mappings

		log.warn("END_______________ AA14: ServiceRequests REST Bootstraping _____________________________");
	}
}
