package aa14b.bootstrap.rest;

import aa14f.common.internal.AA14AppCodes;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import r01f.bootstrap.services.config.core.ServicesCoreBootstrapConfigBuilder;
import r01f.bootstrap.services.config.core.ServicesCoreBootstrapConfigWhenRESTExposed;
import r01f.patterns.IsBuilder;
import r01f.xmlproperties.XMLPropertiesForApp;

/**
 * Builds bootstrap confif
 */
@NoArgsConstructor(access=AccessLevel.PRIVATE)
public abstract class AA14RESTServicesBootstrapConfigBuilder
		   implements IsBuilder {
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	public static ServicesCoreBootstrapConfigWhenRESTExposed buildCoreBootstrapConfig(final XMLPropertiesForApp xmlProps) {
		return ServicesCoreBootstrapConfigBuilder.forCoreAppAndModule(AA14AppCodes.CORE_APPCODE,AA14AppCodes.CORE_APPOINTMENTS_MOD)
	   				.restImplemented()
	   					.bootstrappedBy(AA14RESTServicesBootstrapGuiceModule.class)
	   					.build();
	}
}
