package aa14b.bootstrap.rest;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;

import aa14b.rest.resources.AA14RESTCRUDResourceForOrgDivision;
import aa14b.rest.resources.AA14RESTCRUDResourceForOrgDivisionService;
import aa14b.rest.resources.AA14RESTCRUDResourceForOrganization;
import aa14b.rest.resources.AA14RESTFindResourceForOrgDivision;
import aa14b.rest.resources.AA14RESTFindResourceForOrgDivisionService;
import aa14b.rest.resources.AA14RESTFindResourceForOrganization;
import aa14b.rest.resources.AA14RESTResourceForAppointmentsCalendar;
import aa14b.rest.resources.AA14RESTSearchResource;
import lombok.EqualsAndHashCode;

/**
 * This module binds the REST resources and its delegates
 * (delegation is used to split the logic and maintain REST resources code to a minimum)
 * <p>In order to maintain the REST resource code at a minimum, each REST resource ({appCode}REST{service}ResourceFor{entity}) delegates it's implementation 
 * 	  to a REST Delegate (ie {appCode}REST{Service}DelegateFor{entity}) where all the logic resides</p>
 * <p>In order to do it's work, the REST service delegate will need one or more service(s) implementation(s). These service implementation will be injected to
 *    the REST service resource that will hand them to the delegate</p> 
 *    
 * <p>For example, a CRUD service of an entity named "MyEntity" will have a resource named {appCode}RESTCRUDServiceResourceForMyEntity that will delegate to {appCode}RESTCRUDServiceDelegateForMyEntity</p>
 * <p>The CRUD REST resource ({appCode}RESTCRUDServiceResourceForMyEntity) will be injected with the CRUD service implementation ({appCode}CRUDServicesForMyEntity) that will be handed
 *    to the delegate ({appCode}RESTCRUDServiceDelegateForMyEntity)
 */
@EqualsAndHashCode				// This is important for guice modules
public class AA14RESTResourcesGuiceModule
  implements Module {

	@Override
	public void configure(final Binder binder) {
		binder.bind(AA14RESTApp.class)
			  .in(Singleton.class);

		// ... REST Resources <- all the logic is splitted in DELEGATES in order to maintain resources code to
		//						 a minimum
		// 	   Must configure at least one JAX-RS resource or the
		// 	   server will fail to start.
		binder.bind(AA14RESTCRUDResourceForOrganization.class)
			  .in(Singleton.class);
		binder.bind(AA14RESTFindResourceForOrganization.class)
			  .in(Singleton.class);
		binder.bind(AA14RESTCRUDResourceForOrgDivision.class)
		  	  .in(Singleton.class);
		binder.bind(AA14RESTFindResourceForOrgDivision.class)
		  	  .in(Singleton.class);
		binder.bind(AA14RESTCRUDResourceForOrgDivisionService.class)
			  .in(Singleton.class);
		binder.bind(AA14RESTFindResourceForOrgDivisionService.class)
			  .in(Singleton.class);
		
		binder.bind(AA14RESTResourceForAppointmentsCalendar.class)
			  .in(Singleton.class);
		
		binder.bind(AA14RESTSearchResource.class)
			  .in(Singleton.class);
	}
}
