package aa14b.bootstrap.rest;

import java.util.Set;

import javax.inject.Singleton;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

import com.google.api.client.util.Sets;

import aa14b.rest.resources.AA14RESTCRUDResourceForBookedSlot;
import aa14b.rest.resources.AA14RESTCRUDResourceForOrgDivision;
import aa14b.rest.resources.AA14RESTCRUDResourceForOrgDivisionService;
import aa14b.rest.resources.AA14RESTCRUDResourceForOrgDivisionServiceLocation;
import aa14b.rest.resources.AA14RESTCRUDResourceForOrganization;
import aa14b.rest.resources.AA14RESTFindResourceForBookdeSlot;
import aa14b.rest.resources.AA14RESTFindResourceForOrgDivision;
import aa14b.rest.resources.AA14RESTFindResourceForOrgDivisionService;
import aa14b.rest.resources.AA14RESTFindResourceForOrgDivisionServiceLocation;
import aa14b.rest.resources.AA14RESTFindResourceForOrganization;
import aa14b.rest.resources.AA14RESTResourceForAppointmentsCalendar;
import aa14b.rest.resources.AA14RESTSearchResource;
import aa14f.server.rest.AA14RESTExceptionMappers.AA14PersistenceExceptionMapper;
import aa14f.server.rest.AA14RESTExceptionMappers.AA14UncaughtExceptionMapper;
import aa14f.server.rest.AA14RESTRequestTypeMappers.AA14EnqueuedJobRequestTypeMapper;
import aa14f.server.rest.AA14RESTRequestTypeMappers.AA14IndexManagementCommandRequestTypeMapper;
import aa14f.server.rest.AA14RESTRequestTypeMappers.AA14ModelObjectRequestTypeMapper;
import aa14f.server.rest.AA14RESTRequestTypeMappers.AA14OIDRequestTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.AA14EnqueuedJobdResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.AA14IndexManagementCommandResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.AA14ModelObjectResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.AA14OIDResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.AA14PersistenceOperationResultTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.AA14SearchModelObjectResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.BooleanResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.CollectionResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.DateResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.LongResponseTypeMapper;
import aa14f.server.rest.AA14RESTResponseTypeMappers.MapResponseTypeMapper;
import lombok.NoArgsConstructor;
import r01f.rest.RESTAppBase;
import r01f.rest.RESTResource;


/**
 * Rest app referenced at {@link AA14RESTJerseyServletGuiceModule} (Guice is in use)
 * in order to load the REST resources
 *
 * <pre>
 * NOTE:	If Guice was not used, the REST App should be defined in WEB-INF/web.xml
 * </pre>
 */
@Singleton
@NoArgsConstructor
public class AA14RESTApp
     extends RESTAppBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  REST RESOURCES
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public Set<Class<? extends RESTResource>> getRESTResourceTypes() {
		Set<Class<? extends RESTResource>> outResTypes = Sets.newHashSet();
		
		outResTypes.add(AA14RESTCRUDResourceForOrganization.class);
		outResTypes.add(AA14RESTFindResourceForOrganization.class);
		outResTypes.add(AA14RESTCRUDResourceForOrgDivision.class);
		outResTypes.add(AA14RESTFindResourceForOrgDivision.class);
		outResTypes.add(AA14RESTCRUDResourceForOrgDivisionService.class);
		outResTypes.add(AA14RESTFindResourceForOrgDivisionService.class);
		outResTypes.add(AA14RESTCRUDResourceForOrgDivisionServiceLocation.class);
		outResTypes.add(AA14RESTFindResourceForOrgDivisionServiceLocation.class);
		
		outResTypes.add(AA14RESTCRUDResourceForBookedSlot.class);
		outResTypes.add(AA14RESTFindResourceForBookdeSlot.class);
		
		outResTypes.add(AA14RESTResourceForAppointmentsCalendar.class);
		
		outResTypes.add(AA14RESTSearchResource.class);
		
		return outResTypes;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  MAPPERS
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public Set<Class<? extends MessageBodyReader<?>>> getRequestReceivedTypesMappers() {
		Set<Class<? extends MessageBodyReader<?>>> outMappers = super.getRequestReceivedTypesMappers();
		
		outMappers.add(AA14ModelObjectRequestTypeMapper.class);
		outMappers.add(AA14OIDRequestTypeMapper.class);
		outMappers.add(AA14IndexManagementCommandRequestTypeMapper.class);
		outMappers.add(AA14EnqueuedJobRequestTypeMapper.class);
		
		return outMappers;
	}

	@Override
	public Set<Class<? extends MessageBodyWriter<?>>> getResponseSentTypesMappers() {
		Set<Class<? extends MessageBodyWriter<?>>> outMappers = super.getResponseSentTypesMappers();
		
		// Common response type mappers
		outMappers.add(BooleanResponseTypeMapper.class);
		outMappers.add(LongResponseTypeMapper.class);
		outMappers.add(DateResponseTypeMapper.class);
		outMappers.add(CollectionResponseTypeMapper.class);
		outMappers.add(MapResponseTypeMapper.class);
		
		// Persistence operation results
		outMappers.add(AA14PersistenceOperationResultTypeMapper.class);

		// Model object type mappers
		outMappers.add(AA14OIDResponseTypeMapper.class);
		outMappers.add(AA14ModelObjectResponseTypeMapper.class);
		outMappers.add(AA14SearchModelObjectResponseTypeMapper.class);
		outMappers.add(AA14IndexManagementCommandResponseTypeMapper.class);
		outMappers.add(AA14EnqueuedJobdResponseTypeMapper.class);
		
		return outMappers;
	}

	@Override
	public Set<Class<? extends ExceptionMapper<?>>> getExceptionsMappers() {
		Set<Class<? extends ExceptionMapper<?>>> outMappers = super.getExceptionsMappers();
		
		outMappers.add(AA14PersistenceExceptionMapper.class);
		outMappers.add(AA14UncaughtExceptionMapper.class);
		
		return outMappers;
	}
}
