package aa14a.ui.servlet.delegate;

import java.io.IOException;
import java.util.Collection;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import aa14a.ui.servlet.AA14ControllerOperation;
import aa14a.ui.servlet.AA14ReqParamToType;
import aa14f.client.api.AA14ClientAPI;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceID;
import aa14f.model.oids.AA14IDs.AA14OrgDivisionServiceLocationID;
import aa14f.model.oids.AA14OIDs.AA14AppointmentSubjectID;
import aa14f.model.summaries.AA14SummarizedAppointment;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import r01f.locale.Language;
import r01f.servlet.HttpRequestParamsWrapper;
import r01f.types.contact.NIFPersonID;

@Slf4j
@RequiredArgsConstructor
public class AA14ControllerServletDelegateForAppointmentFind
	 extends AA14ControllerServletDelegateBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  FIELDS
/////////////////////////////////////////////////////////////////////////////////////////
	private final AA14ClientAPI _clientAPI;
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public void executeOp(final HttpServletRequest request,final HttpServletResponse response,
						  final AA14ControllerOperation op,final HttpRequestParamsWrapper reqParams) throws ServletException, 
																 											IOException {
		log.warn("[init]: Find Appointments-----------------");
		
		Language lang = reqParams.getParameter("lang")
								 .asLanguageFromCountryCode()
								 .orDefault(Language.SPANISH);
		NIFPersonID nif = reqParams.getParameter("nif")
								   .asType(NIFPersonID.class)
		 						   .using(AA14ReqParamToType.transform(NIFPersonID.class))
		 						   .orNull();
		AA14AppointmentSubjectID codExp = reqParams.getParameter("codExp")
												   .asType(AA14AppointmentSubjectID.class)
						 						   .using(AA14ReqParamToType.transform(AA14AppointmentSubjectID.class))
						 						   .orNull();
		AA14OrgDivisionServiceID serviceId = reqParams.getParameter("serviceId")
													  .asType(AA14OrgDivisionServiceID.class)
							 						  .using(AA14ReqParamToType.transform(AA14OrgDivisionServiceID.class))
							 						  .orNull();
		AA14OrgDivisionServiceLocationID serviceLocId = reqParams.getParameter("serviceLocId")
													  		     .asType(AA14OrgDivisionServiceLocationID.class)
										 						 .using(AA14ReqParamToType.transform(AA14OrgDivisionServiceLocationID.class))
										 						 .orNull();
		//if (serviceId == null && serviceLocId == null) throw new IllegalArgumentException("Either the service or the location is needed to search for an appointment!");

		Collection <AA14SummarizedAppointment> appointments = null;
		if (nif != null) {
			if (serviceId != null) {
				appointments = _clientAPI.bookedSlotsAPI()
											.getForFind()
												.findAppointmentsByCustomerIdForService(lang,
																						serviceId,
																						nif);
			} else if (serviceLocId != null) {
				appointments = _clientAPI.bookedSlotsAPI()
											.getForFind()
												.findAppointmentsByCustomerIdForServiceLocation(lang,
																								serviceLocId,
																								nif);				
			} else {
				appointments = _clientAPI.bookedSlotsAPI()
											.getForFind()
												.findAppointmentsByCustomerId(lang,
																			  nif);
			}
			_returnJsonResponse(response,
								appointments);  
				
		} else if (codExp != null) {
			if (serviceId != null) {
				appointments = _clientAPI.bookedSlotsAPI()
											.getForFind()
												.findAppointmentsBySubjectIdForService(lang,
																					   serviceId,
																					   codExp);
			} else if (serviceLocId != null) {
				appointments = _clientAPI.bookedSlotsAPI()
											.getForFind()
												.findAppointmentsBySubjectIdForServiceLocation(lang,
																					   		   serviceLocId,
																					   		   codExp);				
			} else {
				appointments = _clientAPI.bookedSlotsAPI()
											.getForFind()
												.findAppointmentsByCustomerId(lang,
																			  nif);
			}
			_returnJsonResponse(response,
								appointments);
		}
		log.warn("[end]: Find Appointments-----------------");
	}
}
