package aa14a.ui.servlet.delegate;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

import com.google.gson.Gson;

import aa14a.ui.servlet.AA14ControllerOperation;
import r01f.servlet.HttpRequestParamsWrapper;
import r01f.util.types.StringConverter.StringConverterFilter;

/**
 * Encapsulates some functions of the controller 
 */
abstract class AA14ControllerServletDelegateBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	protected abstract void executeOp(final HttpServletRequest request,final HttpServletResponse response,
						     		  final AA14ControllerOperation op,final HttpRequestParamsWrapper reqParams) throws ServletException, 
																 											   		    IOException;
	
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	protected static void _returnJsonResponse(final HttpServletResponse response,
							   		 		  final Object obj) throws IOException {
		Gson gson = new Gson();
		String json = gson.toJson(obj);
		response.setContentType("application/json");
		response.setCharacterEncoding("UTF-8");
		response.getWriter().write(json);
	}
	
	protected static PolicyFactory policy =   (Sanitizers.FORMATTING)
										  .and(Sanitizers.BLOCKS);
//										  .and(Sanitizers.LINKS);		// do NOT escape @ character 
	protected static StringConverterFilter FORM_PARAM_SANITIZER_FILTER = new StringConverterFilter() {
																				@Override
																				public String filter(final String untrustedHtml) {
																					String safeHtml = policy.sanitize(untrustedHtml);																					
																					return safeHtml.replace("&#64;","@");		// mega-apa for emails
//																					return safeHtml;
																				}
																   		};
}
